<?php

/**
*
* Reports functions.
* @version 3.3.0
*
**/

defined( 'ABSPATH' ) || exit;

/**
*
* Get bookings, sorted by date.
* @return array - $a
*
**/
function wceb_get_bookings_sorted_by_date() {
    global $wpdb;

    // Booking mode (Days or Nights)
    $booking_mode = get_option( 'wceb_booking_mode' );

    $booked_products = $wpdb->get_results(
        "
        SELECT key1.start, key1.end, key1.qty, key1.order_id, key2.order_item_name
        FROM {$wpdb->prefix}wceb_order_bookings key1
        INNER JOIN {$wpdb->prefix}woocommerce_order_items key2 ON key2.order_item_id = key1.order_item_id
        ORDER BY start ASC
        ", ARRAY_A
    );

    $bookings = apply_filters( 'wceb_reports_booked_products', $booked_products );

    // If no booking, return empty array
    if ( empty( $bookings ) ) {
        return array();
    }
    
    $i = 1;
    $a = array();
    foreach ( $bookings as $index => $booking ) {

    	$start   = $booking['start'];
        $end     = isset( $booking['end'] ) ? $booking['end'] : $start;

        // One date selection in nights mode: set end date to next day
        // Commented because I'm not sure whether to show them overnight or on a single day
        if ( $booking_mode === 'nights' && $start === $end ) {
            // $end = wceb_shift_date( $end, '1' );
        }

        /**
        * @param str  - start date
        * @param str  - end date
        * @param bool - Get dates in the past.
        **/
        $dates = wceb_get_dates_from_daterange( $start, $end, true );

        foreach ( $dates as $date ) {

            $is_start = $date === $start ? true : false;
            $is_end   = $date === $end ? true : false;

            if ( true === $is_start ) {

                if ( isset( $a[$date] ) ) {

                    // If booking starts, fill first empty index of date or add a new index
                    for ( $j = 1; $j <= array_key_last( $a[$date] ); $j++ ) {

                        if ( ! array_key_exists( $j, $a[$date] ) ) {
                            $i = $j;
                            break;
                        } else {
                            $i = $j+1;
                        }

                    }

                } else {
                    $i = 1;
                }
                
            }

            // Compatibility with imported booking from PRO version
            if ( ! isset( $booking['order_id'] ) ) {
                $booking['order_id'] = esc_html__( 'Imported booking', 'woocommerce-easy-booking-system' );
            }

            if ( ! isset( $booking['order_item_name'] ) && isset( $booking['product_id'] ) ) {
                $booking['order_item_name'] = get_the_title( $booking['product_id'] );
            }

            $a[$date][$i] = array( 
                esc_html( wp_strip_all_tags( '#' . $booking['order_id'] . ' - ' . $booking['qty'] . ' x ' . $booking['order_item_name'] ) ),
                $is_start, $is_end
            );

            // Re-index array
            ksort( $a[$date] );

        }

        $i++;

    }

    return $a;

}