<?php

// Upsell.
$wp_customize->add_section(
	'theme_upsell',
	array(
		'title'    => esc_html__( 'Unlock More Features', 'magze' ),
		'priority' => 1,
	)
);
$wp_customize->add_setting(
	'theme_pro_features',
	array(
		'sanitize_callback' => '__return_true',
	)
);
$wp_customize->add_control(
	new Magze_Upsell(
		$wp_customize,
		'theme_pro_features',
		array(
			'section' => 'theme_upsell',
			'type'    => 'upsell',
		)
	)
);

// Front Page.
$wp_customize->add_section(
	new Magze_Section_Features_List(
		$wp_customize,
		'theme_widget_features_home',
		array(
			'title'             => esc_html__( 'Over 16+ Widgets', 'magze' ),
			'description'       => sprintf( __( 'Along with the above sections, this theme comes with wide range of widgets that you can combine in any number and sequences and place in over 10+ widgetareas to build your unique website. <br/> <br/> Go to <a href="%s" target="_blank">widgets</a>.', 'magze' ), esc_url( admin_url( 'widgets.php' ) ) ),
			'features_list'     => array(
				esc_html__( 'Ads Code', 'magze' ),
				esc_html__( 'Adress Info ( 2+ Styles )', 'magze' ),
				esc_html__( 'Author Info ( 3+ Styles )', 'magze' ),
				esc_html__( 'Call To Action ( 4+ Styles )', 'magze' ),
				esc_html__( 'Grid Posts', 'magze' ),
				esc_html__( 'Heading ( 10+ Styles )', 'magze' ),
				esc_html__( 'List Posts ( 11+ Styles )', 'magze' ),
				esc_html__( 'Mailchimp/Newsletter', 'magze' ),
				esc_html__( 'Popular Posts', 'magze' ),
				esc_html__( 'Categories Grid ( 4+ Styles )', 'magze' ),
				esc_html__( 'Posts Overlay Grid ( 7+ Styles )', 'magze' ),
				esc_html__( 'Posts slider ( 2+ Styles )', 'magze' ),
				esc_html__( 'Posts Carousel ( 2+ Styles )', 'magze' ),
				esc_html__( 'Single Column Posts', 'magze' ),
				esc_html__( 'Tab Posts ( 3+ Styles )', 'magze' ),
				esc_html__( 'Social Menu ( 4+ Styles )', 'magze' ),
			),
			'is_upsell_feature' => false,
			'panel'             => 'theme_home_option_panel',
			'priority'          => 999,
		)
	)
);