<?php

/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package sky-enterprise
 * @since 1.0.0
 */

if (function_exists('register_block_style')) {
    /**
     * Register block styles.
     *
     * @since 0.1
     *
     * @return void
     */
    function sky_enterprise_register_block_styles()
    {
        register_block_style(
            'core/columns',
            array(
                'name'  => 'sky-enterprise-boxshadow',
                'label' => __('Box Shadow', 'sky-enterprise')
            )
        );

        register_block_style(
            'core/column',
            array(
                'name'  => 'sky-enterprise-boxshadow',
                'label' => __('Box Shadow', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/column',
            array(
                'name'  => 'sky-enterprise-boxshadow-medium',
                'label' => __('Box Shadow Medium', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/column',
            array(
                'name'  => 'sky-enterprise-boxshadow-large',
                'label' => __('Box Shadow Large', 'sky-enterprise')
            )
        );

        register_block_style(
            'core/group',
            array(
                'name'  => 'sky-enterprise-boxshadow',
                'label' => __('Box Shadow', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'sky-enterprise-boxshadow-medium',
                'label' => __('Box Shadow Medium', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'sky-enterprise-boxshadow-large',
                'label' => __('Box Shadow Larger', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'sky-enterprise-boxshadow',
                'label' => __('Box Shadow', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'sky-enterprise-boxshadow-medium',
                'label' => __('Box Shadow Medium', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'sky-enterprise-boxshadow-larger',
                'label' => __('Box Shadow Large', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'sky-enterprise-image-pulse',
                'label' => __('Iamge Pulse Effect', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'sky-enterprise-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'sky-enterprise-image-hover-pulse',
                'label' => __('Hover Pulse Effect', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'sky-enterprise-image-hover-rotate',
                'label' => __('Hover Rotate Effect', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/columns',
            array(
                'name'  => 'sky-enterprise-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'sky-enterprise')
            )
        );

        register_block_style(
            'core/column',
            array(
                'name'  => 'sky-enterprise-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'sky-enterprise')
            )
        );

        register_block_style(
            'core/group',
            array(
                'name'  => 'sky-enterprise-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'sky-enterprise')
            )
        );

        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-with-round',
                'label' => __('Background with round corner style', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/post-title',
            array(
                'name'  => 'title-hover-primary-color',
                'label' => __('Hover: Primary color', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/post-title',
            array(
                'name'  => 'title-hover-secondary-color',
                'label' => __('Hover: Secondary color', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-primary-color',
                'label' => __('Hover: Primary Color', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-secondary-color',
                'label' => __('Hover: Secondary Color', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-primary-bgcolor',
                'label' => __('Hover: Primary color fill', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-secondary-bgcolor',
                'label' => __('Hover: Secondary color fill', 'sky-enterprise')
            )
        );

        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-primary-color',
                'label' => __('Hover: Primary Color', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-secondary-color',
                'label' => __('Hover: Secondary Color', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-primary-fill',
                'label' => __('Hover: Primary Fill', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-secondary-fill',
                'label' => __('Hover: secondary Fill', 'sky-enterprise')
            )
        );

        register_block_style(
            'core/list',
            array(
                'name'  => 'list-style-no-bullet',
                'label' => __('List Style: Hide bullet', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/list',
            array(
                'name'  => 'hide-bullet-list-link-hover-style-primary',
                'label' => __('Hover style with primary color and hide bullet', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/list',
            array(
                'name'  => 'hide-bullet-list-link-hover-style-secondary',
                'label' => __('Hover style with secondary color and hide bullet', 'sky-enterprise')
            )
        );

        register_block_style(
            'core/gallery',
            array(
                'name'  => 'enable-grayscale-mode-on-image',
                'label' => __('Enable Grayscale Mode on Image', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/social-links',
            array(
                'name'  => 'social-icon-border',
                'label' => __('Border Style', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/page-list',
            array(
                'name'  => 'sky-enterprise-page-list-bullet-hide-style',
                'label' => __('Hide Bullet Style', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/categories',
            array(
                'name'  => 'sky-enterprise-categories-bullet-hide-style',
                'label' => __('Hide Bullet Style', 'sky-enterprise')
            )
        );
        register_block_style(
            'core/cover',
            array(
                'name'  => 'sky-enterprise-cover-round-style',
                'label' => __('Round Corner Style', 'sky-enterprise')
            )
        );
    }
    add_action('init', 'sky_enterprise_register_block_styles');
}
