(function(wp){
    var el = wp.element.createElement,
        registerBlockType = wp.blocks.registerBlockType,
        withSelect = wp.data.withSelect,
        BlockControls = wp.blockEditor.BlockControls,
        AlignmentToolbar = wp.editor.AlignmentToolbar,
        InspectorControls = wp.blocks.InspectorControls,
        ServerSideRender = wp.serverSideRender,
        __ = wp.i18n.__,
        Text = wp.components.TextControl,
        aysSelect = wp.components.SelectControl,
        createBlock = wp.blocks.createBlock,
        select = wp.data.select,
        dispatch = wp.data.dispatch;
    var iconEl = el(
        'svg', 
        { 
            width: 24,
            height: 24,
            viewBox: '0 0 400 400'
        },
        el(
            'g',
            el(
                'path',
                { 
                    d: "M307.400 57.263 C 306.135 58.029,298.800 65.285,298.800 65.770 C 298.800 66.328,307.431 75.000,307.986 75.000 C 308.487 75.000,314.925 68.680,316.129 67.007 C 319.714 62.022,312.620 54.103,307.400 57.263 M244.400 120.151 C 218.348 146.194,196.959 167.724,196.868 167.996 C 196.691 168.526,205.109 177.200,205.801 177.200 C 206.267 177.200,300.915 82.654,301.148 81.956 C 301.315 81.454,292.849 72.800,292.191 72.800 C 291.958 72.800,270.452 94.108,244.400 120.151 M170.832 74.447 C 167.623 75.477,166.745 76.016,164.000 78.649 L 161.800 80.760 139.200 80.895 C 123.820 80.986,116.217 81.172,115.400 81.477 C 114.740 81.723,113.210 82.225,112.000 82.593 C 103.680 85.118,94.594 93.032,92.707 99.400 C 92.577 99.840,92.049 101.280,91.535 102.600 L 90.600 105.000 90.480 198.200 C 90.342 304.765,90.136 298.741,94.189 306.581 C 96.283 310.631,103.568 318.800,105.086 318.800 C 105.286 318.800,105.798 319.115,106.225 319.500 C 107.135 320.322,111.667 322.417,114.800 323.465 C 118.016 324.540,264.944 324.827,269.200 323.767 C 281.416 320.723,289.635 311.697,292.842 297.800 C 293.467 295.093,293.116 103.905,292.486 103.695 C 292.203 103.601,289.233 106.233,285.886 109.543 L 279.800 115.562 279.587 206.281 C 279.434 271.401,279.248 297.395,278.927 298.400 C 276.907 304.737,272.118 309.705,266.427 311.366 C 262.691 312.456,122.737 312.318,118.774 311.220 C 112.520 309.487,107.125 304.454,104.387 297.800 L 103.400 295.400 103.400 201.200 L 103.400 107.000 104.528 104.625 C 105.657 102.249,110.268 97.200,111.309 97.200 C 111.586 97.200,112.529 96.814,113.406 96.343 C 116.769 94.535,118.211 94.429,139.808 94.414 L 160.215 94.400 161.486 96.700 C 163.266 99.923,166.506 102.837,169.758 104.139 L 172.408 105.200 191.104 105.198 C 210.276 105.195,211.304 105.123,214.781 103.534 C 217.118 102.466,220.880 98.586,221.839 96.254 L 222.600 94.403 240.486 94.401 L 258.373 94.400 261.486 91.642 C 263.199 90.126,266.400 87.111,268.600 84.942 L 272.600 81.000 246.800 80.800 L 221.000 80.600 218.600 78.184 C 216.921 76.494,215.479 75.475,213.800 74.790 L 211.400 73.811 192.400 73.717 C 174.173 73.627,173.295 73.656,170.832 74.447 M130.333 121.904 L 123.666 122.019 122.433 123.423 L 121.200 124.828 121.200 134.834 C 121.200 149.146,120.463 148.403,134.660 148.394 C 148.531 148.386,148.000 148.905,148.000 135.328 C 148.000 120.800,149.030 121.582,130.333 121.904 M138.968 126.748 C 139.156 127.053,135.375 134.552,133.732 137.133 L 133.138 138.067 130.574 135.605 C 127.779 132.921,126.325 132.519,126.065 134.357 C 125.910 135.453,132.455 142.400,133.643 142.400 C 134.491 142.400,134.725 142.082,136.886 138.000 C 140.006 132.108,141.660 129.210,142.036 128.978 C 142.617 128.619,142.503 143.337,141.920 143.920 C 141.413 144.427,126.289 144.639,125.033 144.157 C 124.211 143.842,124.069 127.691,124.880 126.880 C 125.449 126.311,138.622 126.188,138.968 126.748 M124.088 157.617 C 123.587 157.818,122.737 158.482,122.201 159.092 L 121.225 160.200 121.213 169.913 C 121.194 184.396,120.406 183.600,134.749 183.600 L 144.739 183.600 145.958 182.574 C 149.483 179.608,148.932 159.286,145.281 157.619 C 144.138 157.098,125.386 157.096,124.088 157.617 M140.134 160.268 C 140.281 160.415,140.153 160.820,139.850 161.168 C 139.546 161.515,138.086 164.050,136.605 166.800 C 132.965 173.557,133.381 173.309,130.571 170.404 C 128.011 167.757,126.334 167.260,126.076 169.071 C 125.892 170.364,132.732 177.247,133.898 176.943 C 134.485 176.789,135.746 174.798,138.183 170.175 C 140.083 166.572,141.809 163.518,142.018 163.389 C 142.744 162.940,142.502 177.841,141.771 178.571 C 140.689 179.654,125.386 179.496,124.798 178.395 C 124.197 177.273,124.242 161.273,124.848 160.543 C 125.326 159.966,139.576 159.710,140.134 160.268 M189.870 179.900 C 187.840 183.138,186.219 186.353,186.483 186.617 C 186.796 186.929,195.200 182.927,195.200 182.466 C 195.200 182.091,191.470 178.400,191.091 178.400 C 190.937 178.400,190.387 179.075,189.870 179.900 M124.600 191.875 C 121.572 192.660,121.200 194.140,121.200 205.386 L 121.200 215.212 122.569 216.706 L 123.938 218.200 134.339 218.200 C 148.784 218.200,147.986 218.967,147.994 205.080 C 148.003 191.079,148.713 191.824,135.259 191.734 C 129.836 191.698,125.040 191.761,124.600 191.875 M140.000 195.367 C 140.000 195.678,139.859 195.993,139.688 196.067 C 139.369 196.202,134.970 204.098,134.097 206.100 C 133.430 207.630,133.006 207.503,130.657 205.067 C 127.825 202.131,126.000 201.746,126.000 204.085 C 126.000 205.081,132.495 211.602,133.479 211.594 C 134.699 211.584,134.977 211.192,138.297 204.814 C 140.069 201.411,141.716 198.561,141.959 198.480 C 142.607 198.264,142.570 211.670,141.920 212.320 C 141.242 212.998,125.558 212.998,124.880 212.320 C 124.202 211.642,124.202 195.958,124.880 195.280 C 125.637 194.523,140.000 194.605,140.000 195.367 M217.000 201.803 C 215.460 202.120,213.840 202.553,213.400 202.764 C 212.960 202.975,211.790 203.516,210.800 203.965 C 207.175 205.609,206.272 206.242,203.257 209.257 C 200.219 212.294,200.443 211.936,197.051 219.161 C 196.438 220.466,196.448 231.963,197.063 233.239 C 197.317 233.768,197.821 234.990,198.182 235.955 C 200.014 240.858,207.837 248.000,211.375 248.000 C 211.719 248.000,212.000 248.147,212.000 248.327 C 212.000 248.507,213.395 248.968,215.100 249.352 C 216.805 249.736,218.560 250.210,219.000 250.406 C 219.440 250.601,221.330 251.059,223.200 251.422 C 225.070 251.786,226.780 252.215,227.000 252.375 C 227.220 252.535,228.480 252.905,229.800 253.198 C 231.120 253.491,232.650 253.944,233.200 254.205 C 237.778 256.374,238.503 256.953,240.204 259.800 C 241.954 262.726,242.013 269.733,240.309 272.307 C 237.589 276.416,233.307 279.033,228.581 279.475 C 227.161 279.607,226.000 279.870,226.000 280.058 C 226.000 280.540,222.101 280.486,221.800 280.000 C 221.664 279.780,220.852 279.600,219.996 279.600 C 217.821 279.600,214.511 278.879,212.504 277.969 C 211.572 277.546,210.656 277.200,210.468 277.200 C 209.882 277.200,205.059 274.705,203.762 273.730 C 203.081 273.218,202.381 272.800,202.205 272.800 C 202.030 272.800,200.938 271.990,199.779 271.000 C 198.459 269.872,197.285 269.200,196.636 269.200 L 195.600 269.200 195.604 276.700 L 195.608 284.200 197.904 285.259 C 199.167 285.841,201.100 286.613,202.200 286.975 C 203.300 287.336,204.740 287.879,205.400 288.181 C 206.060 288.483,207.770 288.941,209.200 289.199 C 210.630 289.456,212.232 289.877,212.760 290.133 C 214.107 290.788,232.311 290.780,233.638 290.125 C 234.167 289.863,235.665 289.355,236.967 288.994 C 238.269 288.634,240.298 287.722,241.475 286.969 C 242.652 286.216,243.754 285.600,243.923 285.600 C 244.237 285.600,248.900 281.134,250.020 279.760 C 250.361 279.342,250.986 278.190,251.409 277.200 C 251.832 276.210,252.313 275.302,252.478 275.183 C 252.643 275.064,253.098 273.714,253.489 272.183 C 253.880 270.652,254.335 269.340,254.500 269.267 C 254.919 269.081,254.878 259.295,254.457 259.035 C 254.269 258.919,253.886 257.746,253.606 256.429 C 253.295 254.964,252.570 253.290,251.737 252.117 C 250.989 251.063,250.004 249.615,249.549 248.900 C 249.094 248.185,248.500 247.600,248.230 247.600 C 247.960 247.600,247.330 247.164,246.830 246.632 C 246.330 246.100,245.354 245.435,244.660 245.155 C 243.967 244.875,243.310 244.540,243.200 244.412 C 243.090 244.283,242.190 243.843,241.200 243.435 C 240.210 243.026,238.860 242.465,238.200 242.188 C 237.540 241.911,235.695 241.457,234.100 241.178 C 232.505 240.900,231.200 240.550,231.200 240.400 C 231.200 240.250,229.895 239.898,228.300 239.618 C 226.705 239.337,225.220 238.978,225.000 238.821 C 224.780 238.663,223.520 238.296,222.200 238.004 C 212.368 235.834,207.676 229.147,210.031 220.664 C 210.596 218.628,214.903 214.287,217.043 213.598 C 217.899 213.322,218.780 212.955,219.000 212.783 C 220.577 211.552,232.986 211.544,234.600 212.773 C 234.820 212.941,235.990 213.393,237.200 213.779 C 238.410 214.165,239.490 214.597,239.600 214.740 C 239.710 214.883,241.016 215.599,242.501 216.331 C 243.987 217.063,246.180 218.458,247.374 219.431 C 248.686 220.500,249.953 221.200,250.573 221.200 L 251.600 221.200 251.600 213.790 L 251.600 206.380 250.500 205.998 C 249.895 205.788,248.925 205.362,248.345 205.052 C 247.764 204.742,245.964 204.155,244.345 203.747 C 242.725 203.340,241.310 202.895,241.200 202.758 C 240.198 201.518,221.892 200.795,217.000 201.803 M125.844 226.289 C 121.574 226.744,121.200 227.815,121.200 239.600 C 121.200 253.616,120.380 252.800,134.461 252.800 C 148.623 252.800,148.000 253.401,148.000 239.731 C 148.000 225.886,148.173 226.074,135.400 226.104 C 131.000 226.115,126.700 226.198,125.844 226.289 M141.771 229.829 C 142.498 230.555,142.710 245.690,142.009 246.800 C 141.527 247.564,126.562 247.929,125.218 247.210 C 124.043 246.581,123.934 230.311,125.100 229.632 C 126.345 228.907,141.023 229.080,141.771 229.829 ",
                    fill: '#fbfbfa',
                    stroke: 'none',
                    'fill-rule': 'evenodd'
                }
            ),
            el(
                'path',
                { 
                    d: "M186.400 0.397 C 184.090 0.578,180.850 0.830,179.200 0.956 C 174.538 1.312,172.382 1.647,172.589 1.983 C 172.694 2.152,171.209 2.401,169.290 2.537 C 163.423 2.953,160.284 3.489,160.612 4.020 C 160.749 4.241,160.008 4.400,158.847 4.400 C 157.747 4.400,156.745 4.565,156.621 4.767 C 156.496 4.968,155.594 5.133,154.615 5.133 C 153.637 5.133,152.333 5.400,151.718 5.726 C 151.103 6.052,149.340 6.537,147.800 6.804 C 146.260 7.071,144.640 7.512,144.200 7.783 C 143.428 8.259,142.336 8.570,139.800 9.035 C 139.140 9.156,138.420 9.483,138.200 9.761 C 137.980 10.040,136.968 10.381,135.951 10.519 C 133.773 10.815,131.938 11.576,132.236 12.058 C 132.352 12.246,131.817 12.400,131.047 12.400 C 130.277 12.400,129.551 12.556,129.432 12.747 C 129.314 12.939,128.494 13.211,127.609 13.352 C 126.724 13.494,125.998 13.742,125.997 13.905 C 125.995 14.067,124.917 14.536,123.601 14.946 C 122.286 15.356,121.308 15.851,121.428 16.046 C 121.549 16.241,121.277 16.400,120.824 16.400 C 120.371 16.400,120.000 16.580,120.000 16.800 C 120.000 17.020,119.565 17.200,119.033 17.200 C 117.723 17.200,116.756 17.606,117.026 18.042 C 117.148 18.239,116.797 18.400,116.247 18.400 C 115.697 18.400,115.136 18.580,115.000 18.800 C 114.864 19.020,114.403 19.200,113.976 19.200 C 113.549 19.200,113.200 19.464,113.200 19.787 C 113.200 20.114,112.962 20.284,112.664 20.169 C 112.369 20.056,111.897 20.242,111.615 20.582 C 111.333 20.922,110.674 21.200,110.151 21.200 C 109.560 21.200,109.200 21.434,109.200 21.818 C 109.200 22.157,108.975 22.385,108.700 22.324 C 108.024 22.173,105.600 23.209,105.600 23.649 C 105.600 23.842,105.343 24.000,105.029 24.000 C 104.714 24.000,104.176 24.281,103.832 24.626 C 103.488 24.970,103.045 25.152,102.848 25.030 C 102.652 24.908,102.261 25.086,101.980 25.424 C 101.699 25.763,100.689 26.395,99.735 26.830 C 98.781 27.264,98.000 27.795,98.000 28.010 C 98.000 28.224,97.654 28.400,97.231 28.400 C 96.808 28.400,95.953 28.817,95.331 29.327 C 94.709 29.837,93.615 30.489,92.900 30.775 C 92.185 31.062,91.600 31.556,91.600 31.872 C 91.600 32.188,91.408 32.328,91.173 32.183 C 90.937 32.038,90.646 32.303,90.522 32.776 C 90.399 33.247,90.096 33.559,89.849 33.469 C 89.315 33.275,87.200 34.426,87.200 34.910 C 87.200 35.095,87.035 35.145,86.832 35.020 C 86.630 34.895,86.225 35.022,85.932 35.302 C 85.640 35.581,84.893 36.135,84.274 36.532 C 82.479 37.681,81.600 38.536,81.600 39.132 C 81.600 39.463,81.356 39.592,80.991 39.452 C 80.656 39.323,80.062 39.529,79.671 39.909 C 79.280 40.289,78.352 41.050,77.608 41.600 C 75.488 43.169,73.812 44.572,73.667 44.900 C 73.593 45.065,73.368 45.200,73.167 45.200 C 72.965 45.200,72.480 45.515,72.089 45.900 C 71.699 46.285,70.787 47.093,70.063 47.696 C 69.276 48.352,68.865 48.982,69.040 49.264 C 69.238 49.585,69.114 49.653,68.650 49.475 C 68.229 49.313,67.883 49.439,67.742 49.807 C 67.617 50.133,67.260 50.400,66.949 50.400 C 66.637 50.400,66.185 50.835,65.943 51.366 C 65.701 51.897,65.151 52.424,64.722 52.536 C 64.292 52.649,63.843 53.114,63.724 53.570 C 63.604 54.027,63.298 54.400,63.042 54.400 C 62.787 54.400,62.280 54.715,61.917 55.100 C 61.554 55.485,61.019 56.020,60.728 56.289 C 60.438 56.558,59.967 57.008,59.683 57.289 C 55.279 61.645,54.400 62.614,54.400 63.110 C 54.400 63.275,53.995 63.590,53.500 63.809 C 53.005 64.029,52.625 64.522,52.656 64.904 C 52.686 65.287,52.461 65.600,52.156 65.600 C 51.850 65.600,51.600 65.780,51.600 66.000 C 51.600 66.220,51.330 66.400,51.000 66.400 C 50.670 66.400,50.400 66.599,50.400 66.842 C 50.400 67.086,49.935 67.651,49.366 68.098 C 48.569 68.725,48.455 68.988,48.866 69.249 C 49.289 69.517,49.269 69.589,48.773 69.594 C 48.024 69.601,45.327 72.617,41.600 77.618 C 41.050 78.356,40.271 79.298,39.869 79.711 C 39.467 80.124,39.236 80.718,39.357 81.031 C 39.477 81.344,39.351 81.600,39.076 81.600 C 38.496 81.600,37.635 82.541,36.578 84.330 C 36.165 85.028,35.698 85.600,35.541 85.600 C 35.383 85.600,35.130 85.989,34.979 86.466 C 34.710 87.315,32.109 91.193,31.527 91.614 C 31.364 91.732,30.964 92.466,30.639 93.246 C 30.313 94.026,29.775 94.889,29.444 95.164 C 29.112 95.439,28.638 96.280,28.389 97.032 C 28.141 97.784,27.817 98.401,27.669 98.402 C 27.521 98.404,26.590 99.972,25.600 101.887 C 24.610 103.803,23.586 105.604,23.324 105.889 C 23.063 106.175,22.622 107.037,22.344 107.804 C 22.066 108.572,21.710 109.200,21.551 109.200 C 21.393 109.200,21.145 109.738,21.001 110.395 C 20.857 111.053,20.572 111.694,20.369 111.819 C 20.166 111.945,20.000 112.407,20.000 112.847 C 20.000 113.287,19.839 113.548,19.643 113.427 C 19.447 113.305,19.048 114.015,18.756 115.003 C 18.464 115.991,18.099 116.800,17.944 116.800 C 17.515 116.800,16.698 119.557,16.940 120.187 C 17.190 120.839,16.275 121.728,15.799 121.297 C 15.620 121.133,15.586 121.315,15.724 121.700 C 15.862 122.085,15.808 122.400,15.604 122.400 C 15.399 122.400,15.009 123.165,14.736 124.100 C 14.462 125.035,14.126 125.890,13.989 126.000 C 13.765 126.179,12.424 129.997,12.233 131.000 C 12.191 131.220,11.851 131.976,11.478 132.680 C 11.105 133.384,10.794 134.284,10.786 134.680 C 10.779 135.076,10.425 136.120,10.001 137.000 C 9.576 137.880,9.018 139.635,8.762 140.900 C 8.506 142.165,8.169 143.200,8.015 143.200 C 7.860 143.200,7.715 143.425,7.693 143.700 C 7.599 144.849,6.336 149.855,5.974 150.509 C 5.758 150.899,5.275 153.059,4.899 155.309 C 4.524 157.559,4.102 159.490,3.962 159.600 C 3.568 159.910,2.109 169.627,2.326 170.500 C 2.367 170.665,2.247 170.800,2.061 170.800 C 1.282 170.800,0.308 186.261,0.272 199.200 C 0.227 215.429,0.789 226.000,1.697 226.000 C 1.942 226.000,2.024 226.712,1.902 227.793 C 1.759 229.058,1.832 229.506,2.150 229.316 C 2.397 229.168,2.330 229.386,2.000 229.800 C 1.632 230.262,1.597 230.435,1.909 230.248 C 2.274 230.028,2.407 230.259,2.383 231.071 C 2.327 232.881,3.290 238.400,3.661 238.400 C 4.171 238.400,4.068 239.911,3.546 240.085 C 3.244 240.185,3.299 240.442,3.713 240.855 C 4.053 241.196,4.458 242.313,4.612 243.338 C 4.765 244.362,5.027 245.200,5.193 245.200 C 5.359 245.200,5.411 245.925,5.309 246.811 C 5.194 247.802,5.338 248.765,5.682 249.311 C 5.990 249.800,6.277 250.740,6.322 251.400 C 6.366 252.060,6.626 252.780,6.901 253.000 C 7.181 253.224,7.347 254.030,7.280 254.834 C 7.202 255.762,7.379 256.450,7.780 256.783 C 8.484 257.368,8.633 258.191,7.959 257.774 C 7.716 257.624,7.788 257.929,8.119 258.451 C 8.450 258.973,8.843 259.985,8.993 260.700 C 9.142 261.415,9.449 262.000,9.675 262.000 C 9.901 262.000,9.982 262.270,9.855 262.600 C 9.729 262.930,9.844 263.203,10.113 263.206 C 10.461 263.210,10.447 263.309,10.066 263.550 C 9.637 263.823,9.656 263.936,10.166 264.132 C 10.515 264.265,10.800 264.730,10.800 265.164 C 10.800 265.598,10.983 266.066,11.207 266.204 C 11.430 266.342,11.509 266.623,11.383 266.828 C 11.256 267.032,11.335 267.200,11.558 267.200 C 11.908 267.200,12.350 268.708,12.613 270.800 C 12.655 271.130,12.789 271.670,12.911 272.000 C 13.033 272.330,13.243 273.102,13.378 273.716 C 13.532 274.414,13.794 274.727,14.080 274.551 C 14.377 274.367,14.451 274.491,14.292 274.905 C 14.157 275.255,14.319 275.767,14.652 276.043 C 14.984 276.319,15.173 276.860,15.072 277.246 C 14.880 277.980,15.769 279.567,16.684 280.125 C 16.977 280.303,17.112 280.618,16.985 280.825 C 16.857 281.031,16.924 281.200,17.132 281.200 C 17.341 281.200,17.757 282.033,18.056 283.050 C 18.355 284.068,18.826 284.988,19.102 285.094 C 19.378 285.200,19.717 285.988,19.853 286.844 C 19.990 287.700,20.311 288.400,20.566 288.400 C 20.821 288.400,21.057 288.762,21.090 289.204 C 21.124 289.646,21.432 290.289,21.775 290.633 C 22.370 291.227,22.573 291.995,22.430 293.100 C 22.394 293.375,22.653 293.600,23.006 293.600 C 23.369 293.600,23.530 293.790,23.376 294.038 C 23.027 294.603,23.983 296.400,24.632 296.400 C 24.925 296.400,25.084 296.811,25.020 297.400 C 24.954 297.996,25.114 298.400,25.415 298.400 C 25.692 298.400,26.243 299.300,26.639 300.400 C 27.163 301.858,27.567 302.400,28.128 302.400 C 28.801 302.400,28.829 302.485,28.349 303.077 C 27.880 303.654,27.883 303.703,28.368 303.411 C 28.794 303.154,28.872 303.235,28.681 303.734 C 28.515 304.165,28.628 304.400,29.000 304.400 C 29.349 304.400,29.484 304.638,29.343 305.005 C 29.177 305.437,29.294 305.539,29.755 305.362 C 30.263 305.167,30.400 305.379,30.400 306.357 C 30.400 307.169,30.599 307.600,30.973 307.600 C 31.288 307.600,31.655 307.943,31.788 308.363 C 31.921 308.783,32.275 309.220,32.575 309.335 C 32.874 309.450,33.332 310.187,33.591 310.972 C 33.850 311.757,34.329 312.400,34.655 312.400 C 34.981 312.400,35.145 312.565,35.021 312.766 C 34.897 312.967,34.931 313.192,35.098 313.266 C 35.264 313.340,35.743 314.075,36.163 314.900 C 36.583 315.725,37.168 316.400,37.463 316.400 C 37.758 316.400,38.000 316.663,38.000 316.984 C 38.000 317.306,38.383 317.926,38.851 318.362 C 39.346 318.823,39.603 319.416,39.464 319.778 C 39.315 320.167,39.445 320.400,39.813 320.400 C 40.136 320.400,40.355 320.625,40.300 320.900 C 40.245 321.175,40.439 321.350,40.731 321.290 C 41.023 321.229,41.467 321.724,41.719 322.390 C 41.970 323.055,42.327 323.600,42.511 323.600 C 42.696 323.600,42.736 323.780,42.600 324.000 C 42.464 324.220,42.653 324.400,43.019 324.400 C 43.447 324.400,43.603 324.615,43.455 325.000 C 43.313 325.372,43.457 325.600,43.836 325.600 C 44.172 325.600,44.336 325.780,44.200 326.000 C 44.064 326.220,44.323 326.400,44.776 326.400 C 45.229 326.400,45.577 326.535,45.548 326.700 C 45.406 327.515,46.629 329.598,47.135 329.403 C 47.504 329.262,47.612 329.392,47.457 329.795 C 47.296 330.215,47.479 330.400,48.055 330.400 C 48.616 330.400,48.813 330.588,48.663 330.980 C 48.515 331.367,48.633 331.485,49.020 331.337 C 49.339 331.214,49.600 331.326,49.600 331.584 C 49.600 331.842,50.205 332.627,50.944 333.327 C 51.684 334.027,52.416 335.005,52.571 335.500 C 52.727 335.995,53.120 336.400,53.446 336.400 C 54.348 336.400,55.990 338.362,55.706 339.101 C 55.518 339.590,55.631 339.674,56.191 339.459 C 56.676 339.273,57.174 339.451,57.676 339.989 C 58.091 340.435,58.300 340.800,58.140 340.800 C 57.980 340.800,58.236 341.160,58.708 341.600 C 59.180 342.040,59.735 342.400,59.940 342.400 C 60.420 342.400,60.872 343.560,60.578 344.036 C 60.454 344.236,60.833 344.400,61.419 344.400 C 62.203 344.400,62.425 344.559,62.255 345.000 C 62.099 345.407,62.276 345.600,62.805 345.600 C 63.303 345.600,63.675 345.961,63.836 346.600 C 63.993 347.226,64.370 347.600,64.843 347.600 C 65.260 347.600,65.600 347.791,65.600 348.024 C 65.600 348.257,65.392 348.319,65.138 348.162 C 64.867 347.994,64.784 348.051,64.939 348.301 C 65.083 348.534,65.606 348.621,66.100 348.493 C 66.902 348.287,66.940 348.334,66.451 348.931 C 65.969 349.519,66.005 349.600,66.751 349.600 C 67.218 349.600,67.600 349.780,67.600 350.000 C 67.600 350.220,67.981 350.400,68.447 350.400 C 69.097 350.400,69.245 350.586,69.084 351.201 C 68.969 351.641,69.038 351.900,69.237 351.777 C 69.437 351.654,69.600 351.828,69.600 352.164 C 69.600 352.571,69.824 352.689,70.269 352.518 C 70.777 352.323,70.877 352.423,70.682 352.931 C 70.495 353.417,70.641 353.600,71.213 353.600 C 71.646 353.600,72.000 353.853,72.000 354.163 C 72.000 354.528,72.280 354.652,72.800 354.516 C 73.664 354.290,73.925 355.002,73.100 355.335 C 72.825 355.446,73.095 355.551,73.700 355.568 C 74.334 355.587,74.758 355.804,74.700 356.082 C 74.645 356.347,74.870 356.580,75.200 356.600 C 75.530 356.620,75.755 356.853,75.700 357.118 C 75.645 357.383,75.960 357.600,76.400 357.600 C 76.840 357.600,77.155 357.825,77.100 358.100 C 77.045 358.375,77.293 358.552,77.652 358.494 C 78.033 358.431,78.395 358.738,78.525 359.234 C 78.647 359.701,78.938 359.962,79.173 359.817 C 79.408 359.672,79.600 359.808,79.600 360.121 C 79.600 360.511,79.913 360.629,80.600 360.498 C 81.333 360.358,81.600 360.479,81.600 360.953 C 81.600 361.309,81.870 361.600,82.200 361.600 C 82.530 361.600,82.800 361.864,82.800 362.187 C 82.800 362.545,83.035 362.685,83.400 362.545 C 83.815 362.386,84.000 362.571,84.000 363.145 C 84.000 363.718,84.185 363.904,84.600 363.745 C 84.977 363.600,85.200 363.749,85.200 364.145 C 85.200 364.531,85.425 364.689,85.781 364.552 C 86.632 364.226,87.436 364.804,86.743 365.244 C 86.346 365.495,86.443 365.589,87.100 365.594 C 87.604 365.597,88.000 365.848,88.000 366.163 C 88.000 366.533,88.280 366.652,88.822 366.510 C 89.576 366.313,91.570 367.820,91.303 368.386 C 91.250 368.499,91.520 368.593,91.903 368.596 C 92.287 368.598,92.555 368.825,92.500 369.100 C 92.437 369.414,92.862 369.600,93.643 369.600 C 94.621 369.600,94.833 369.737,94.638 370.245 C 94.459 370.711,94.562 370.823,95.011 370.651 C 95.366 370.515,95.728 370.667,95.858 371.007 C 95.983 371.333,96.511 371.600,97.030 371.600 C 97.746 371.600,97.913 371.761,97.720 372.264 C 97.518 372.791,97.644 372.882,98.333 372.702 C 98.919 372.548,99.200 372.657,99.200 373.037 C 99.200 373.371,99.607 373.600,100.200 373.600 C 100.777 373.600,101.200 373.830,101.200 374.145 C 101.200 374.510,101.529 374.626,102.200 374.498 C 102.926 374.359,103.200 374.480,103.200 374.939 C 103.200 375.673,104.640 376.591,105.800 376.596 C 106.240 376.598,106.555 376.825,106.500 377.100 C 106.435 377.424,106.893 377.600,107.800 377.600 C 108.570 377.600,109.200 377.799,109.200 378.043 C 109.200 378.286,108.921 378.378,108.579 378.247 C 108.201 378.102,108.061 378.175,108.220 378.432 C 108.363 378.664,108.733 378.758,109.040 378.640 C 109.911 378.306,111.007 378.823,110.334 379.250 C 109.994 379.465,110.418 379.590,111.500 379.594 C 112.435 379.597,113.200 379.791,113.200 380.024 C 113.200 380.257,113.020 380.336,112.800 380.200 C 112.580 380.064,112.400 380.150,112.400 380.392 C 112.400 380.633,112.895 380.778,113.500 380.715 C 114.212 380.641,114.565 380.776,114.500 381.100 C 114.435 381.426,114.902 381.600,115.843 381.600 C 116.966 381.600,117.234 381.734,117.053 382.205 C 116.872 382.678,117.035 382.756,117.801 382.564 C 118.557 382.374,119.070 382.608,120.055 383.593 C 120.983 384.522,121.593 384.818,122.297 384.684 C 122.889 384.570,123.345 384.712,123.474 385.049 C 123.591 385.352,124.206 385.600,124.843 385.600 C 125.555 385.600,125.962 385.792,125.900 386.100 C 125.835 386.426,126.420 386.644,127.580 386.727 C 128.847 386.817,129.193 386.960,128.780 387.221 C 128.375 387.477,128.712 387.590,129.900 387.594 C 131.044 387.598,131.567 387.763,131.500 388.100 C 131.435 388.424,131.894 388.600,132.800 388.600 C 133.706 388.601,134.165 388.777,134.100 389.100 C 134.045 389.375,134.135 389.579,134.300 389.553 C 135.458 389.370,137.600 389.675,137.600 390.024 C 137.600 390.257,137.392 390.319,137.138 390.162 C 136.852 389.985,136.785 390.052,136.962 390.338 C 137.119 390.592,137.957 390.800,138.824 390.800 C 139.691 390.800,140.400 390.980,140.400 391.200 C 140.400 391.420,141.011 391.600,141.757 391.600 C 142.624 391.600,143.202 391.828,143.356 392.231 C 143.526 392.674,144.012 392.826,144.990 392.742 C 145.755 392.676,146.602 392.842,146.871 393.111 C 147.140 393.380,148.134 393.600,149.080 393.600 C 150.243 393.600,150.768 393.762,150.700 394.100 C 150.630 394.449,151.267 394.610,152.800 394.633 C 155.784 394.677,156.087 394.735,155.794 395.210 C 155.655 395.435,155.689 395.594,155.870 395.563 C 157.555 395.270,159.950 395.664,159.745 396.200 C 159.553 396.699,159.995 396.800,162.357 396.800 C 163.921 396.800,165.200 396.973,165.200 397.185 C 165.200 397.397,166.865 397.622,168.900 397.685 C 171.599 397.769,172.573 397.935,172.500 398.300 C 172.425 398.674,173.436 398.802,176.500 398.806 C 178.974 398.810,180.383 398.950,180.052 399.159 C 179.199 399.700,199.590 400.136,210.198 399.804 C 215.369 399.643,219.600 399.351,219.600 399.155 C 219.600 398.960,221.574 398.800,223.987 398.800 C 227.723 398.800,228.341 398.711,228.145 398.200 C 227.951 397.695,228.461 397.600,231.357 397.600 C 233.386 397.600,234.800 397.436,234.800 397.200 C 234.800 396.971,236.016 396.800,237.649 396.800 C 240.136 396.800,240.435 396.724,240.000 396.200 C 239.567 395.678,239.816 395.600,241.918 395.600 C 243.403 395.600,244.393 395.420,244.489 395.133 C 244.574 394.877,245.264 394.687,246.022 394.712 C 248.273 394.786,250.232 394.391,249.587 393.992 C 249.226 393.769,249.642 393.656,250.772 393.672 C 252.006 393.689,252.624 393.500,252.891 393.024 C 253.168 392.528,253.571 392.418,254.425 392.605 C 255.799 392.907,257.315 392.509,256.962 391.939 C 256.824 391.715,257.044 391.570,257.456 391.614 C 258.980 391.775,260.040 391.588,259.800 391.200 C 259.651 390.959,260.188 390.800,261.153 390.800 C 262.747 390.800,263.658 390.251,262.702 389.866 C 262.426 389.754,263.055 389.649,264.100 389.632 C 265.145 389.614,266.000 389.420,266.000 389.200 C 266.000 388.980,266.531 388.800,267.180 388.800 C 267.829 388.800,268.504 388.554,268.680 388.254 C 268.856 387.954,269.540 387.606,270.200 387.481 C 272.923 386.968,274.194 386.506,274.100 386.066 C 274.041 385.793,274.496 385.600,275.200 385.600 C 275.991 385.600,276.400 385.399,276.400 385.010 C 276.400 384.576,276.699 384.480,277.533 384.647 C 278.439 384.828,278.918 384.621,279.930 383.609 C 280.840 382.699,281.419 382.416,281.997 382.599 C 282.568 382.780,282.800 382.673,282.800 382.227 C 282.800 381.802,283.173 381.600,283.957 381.600 C 284.625 381.600,285.213 381.342,285.348 380.990 C 285.511 380.567,285.922 380.445,286.691 380.593 C 287.301 380.709,287.575 380.699,287.300 380.569 C 286.464 380.175,286.741 379.600,287.767 379.600 C 288.298 379.600,288.797 379.409,288.875 379.176 C 288.952 378.943,289.642 378.688,290.408 378.611 C 292.308 378.418,292.274 378.436,291.600 378.000 C 291.145 377.706,291.314 377.611,292.300 377.606 C 293.211 377.602,293.600 377.412,293.600 376.973 C 293.600 376.523,293.831 376.420,294.419 376.606 C 295.029 376.800,295.525 376.536,296.368 375.571 C 297.118 374.712,297.718 374.360,298.149 374.525 C 298.568 374.686,298.800 374.566,298.800 374.187 C 298.800 373.828,299.187 373.600,299.800 373.600 C 300.350 373.600,300.800 373.412,300.800 373.182 C 300.800 372.953,301.115 372.818,301.500 372.882 C 301.960 372.960,302.181 372.760,302.144 372.300 C 302.103 371.782,302.389 371.600,303.244 371.600 C 303.956 371.600,304.362 371.408,304.300 371.100 C 304.238 370.792,304.544 370.648,305.097 370.725 C 305.771 370.818,305.934 370.694,305.754 370.225 C 305.575 369.757,305.776 369.600,306.557 369.600 C 307.217 369.600,307.600 369.380,307.600 369.000 C 307.600 368.431,308.112 368.207,309.000 368.386 C 309.220 368.430,309.280 368.347,309.133 368.200 C 308.660 367.727,310.434 366.316,311.237 366.526 C 311.729 366.654,312.000 366.519,312.000 366.145 C 312.000 365.814,312.301 365.615,312.700 365.682 C 313.194 365.765,313.362 365.578,313.270 365.045 C 313.167 364.448,313.319 364.338,314.002 364.516 C 314.663 364.689,314.808 364.598,314.626 364.123 C 314.447 363.656,314.587 363.556,315.194 363.714 C 315.794 363.871,316.000 363.730,316.000 363.163 C 316.000 362.743,316.270 362.400,316.600 362.400 C 316.930 362.400,317.200 362.220,317.200 362.000 C 317.200 361.780,317.470 361.600,317.800 361.600 C 318.130 361.600,318.400 361.309,318.400 360.953 C 318.400 360.479,318.667 360.358,319.400 360.498 C 320.071 360.626,320.400 360.510,320.400 360.145 C 320.400 359.845,320.754 359.600,321.187 359.600 C 321.740 359.600,321.903 359.412,321.733 358.970 C 321.558 358.513,321.699 358.376,322.246 358.470 C 322.686 358.546,322.958 358.392,322.900 358.100 C 322.845 357.825,323.049 357.600,323.353 357.600 C 323.658 357.600,324.018 357.285,324.154 356.900 C 324.289 356.515,324.514 355.950,324.652 355.644 C 324.804 355.309,324.735 355.193,324.478 355.352 C 324.059 355.610,320.790 354.514,320.400 353.983 C 320.057 353.518,317.671 352.400,317.020 352.400 C 316.679 352.400,316.400 352.225,316.400 352.011 C 316.400 351.798,314.825 350.885,312.900 349.984 C 310.975 349.082,309.130 348.173,308.800 347.962 C 308.470 347.752,307.255 347.121,306.100 346.560 C 304.945 346.000,304.000 345.330,303.999 345.071 C 303.999 344.812,303.445 344.561,302.769 344.514 C 302.092 344.466,300.878 344.017,300.069 343.514 C 297.686 342.034,295.621 340.906,291.800 339.000 C 289.820 338.012,287.930 337.037,287.600 336.833 C 287.270 336.629,285.560 335.773,283.800 334.931 C 282.040 334.089,280.510 333.293,280.400 333.162 C 280.290 333.031,279.697 332.671,279.083 332.362 C 270.424 328.007,267.681 326.564,267.058 326.033 C 266.388 325.462,259.104 325.390,192.158 325.296 C 143.577 325.228,118.000 325.055,118.000 324.796 C 118.000 324.578,117.201 324.400,116.224 324.400 C 115.247 324.400,114.336 324.220,114.200 324.000 C 114.064 323.780,113.616 323.600,113.205 323.600 C 112.794 323.600,112.187 323.330,111.857 323.000 C 111.527 322.670,110.627 322.400,109.858 322.400 C 108.841 322.400,108.243 322.126,107.671 321.400 C 107.239 320.850,106.506 320.400,106.042 320.400 C 105.579 320.400,105.200 320.214,105.200 319.987 C 105.200 319.761,104.885 319.460,104.500 319.320 C 104.115 319.180,103.206 318.466,102.481 317.733 C 101.755 317.000,100.900 316.400,100.581 316.400 C 100.261 316.400,100.000 316.265,100.000 316.100 C 99.999 315.935,99.594 315.320,99.100 314.734 C 98.605 314.147,97.885 313.290,97.500 312.829 C 97.115 312.368,96.800 311.828,96.800 311.629 C 96.800 311.430,96.656 311.207,96.480 311.133 C 95.708 310.812,92.330 304.702,91.792 302.654 C 91.466 301.414,90.930 299.372,90.600 298.116 C 89.730 294.803,89.716 109.152,90.585 104.273 C 91.212 100.759,93.723 95.191,95.615 93.119 C 96.267 92.405,96.800 91.682,96.800 91.511 C 96.800 91.138,98.293 89.600,98.654 89.600 C 98.794 89.600,99.325 89.150,99.835 88.600 C 100.345 88.050,100.869 87.600,100.999 87.600 C 101.130 87.600,101.670 87.195,102.199 86.700 C 103.881 85.128,104.352 84.800,104.934 84.800 C 105.246 84.800,105.726 84.530,106.000 84.200 C 106.274 83.870,106.926 83.600,107.449 83.600 C 107.972 83.600,108.400 83.456,108.400 83.279 C 108.400 82.867,111.930 81.595,113.067 81.598 C 113.543 81.599,114.008 81.375,114.100 81.100 C 114.230 80.710,119.300 80.574,137.233 80.482 C 161.439 80.357,161.878 80.324,162.847 78.511 C 163.116 78.010,163.504 77.600,163.710 77.600 C 163.916 77.600,164.439 77.150,164.871 76.600 C 165.304 76.050,166.005 75.600,166.429 75.600 C 166.853 75.600,167.200 75.455,167.200 75.277 C 167.200 73.803,169.851 73.600,189.134 73.600 C 201.445 73.600,208.000 73.461,208.000 73.200 C 208.000 72.980,208.360 72.800,208.800 72.800 C 209.240 72.800,209.600 72.980,209.600 73.200 C 209.600 73.420,210.455 73.606,211.500 73.613 C 212.545 73.620,213.749 73.890,214.176 74.213 C 214.604 74.536,215.279 74.800,215.676 74.800 C 216.074 74.800,216.400 74.980,216.400 75.200 C 216.400 75.420,216.574 75.600,216.787 75.600 C 217.000 75.600,218.305 76.691,219.687 78.024 L 222.200 80.448 247.700 80.324 C 271.767 80.207,273.200 80.239,273.200 80.900 C 273.200 81.285,273.020 81.600,272.800 81.600 C 272.580 81.600,272.400 81.870,272.400 82.200 C 272.400 82.530,272.159 82.800,271.864 82.800 C 271.570 82.800,271.123 83.250,270.873 83.800 C 270.622 84.350,270.174 84.800,269.876 84.800 C 269.579 84.800,269.094 85.250,268.800 85.800 C 268.506 86.350,268.088 86.800,267.872 86.800 C 267.656 86.800,266.189 88.150,264.613 89.800 C 263.036 91.450,261.604 92.800,261.430 92.800 C 261.257 92.800,260.761 93.250,260.329 93.800 L 259.542 94.800 241.439 94.800 L 223.337 94.800 222.400 96.800 C 221.885 97.900,221.314 98.800,221.132 98.800 C 220.949 98.800,220.800 98.988,220.800 99.217 C 220.800 99.446,220.625 99.851,220.411 100.117 C 219.033 101.830,218.054 102.800,217.703 102.800 C 217.480 102.800,217.074 103.070,216.800 103.400 C 216.526 103.730,215.964 104.000,215.551 104.000 C 215.138 104.000,214.800 104.180,214.800 104.400 C 214.800 104.620,214.386 104.800,213.880 104.800 C 213.374 104.800,212.735 105.025,212.460 105.300 C 212.079 105.681,207.722 105.828,194.092 105.920 C 181.294 106.005,176.143 106.168,175.942 106.494 C 175.734 106.830,175.520 106.832,175.120 106.500 C 174.823 106.253,173.640 105.927,172.490 105.774 C 171.341 105.622,170.400 105.340,170.400 105.148 C 170.400 104.957,170.055 104.800,169.632 104.800 C 168.765 104.800,166.406 103.558,166.403 103.100 C 166.401 102.935,166.206 102.800,165.969 102.800 C 165.438 102.800,162.400 99.777,162.400 99.249 C 162.400 99.039,162.258 98.807,162.086 98.733 C 161.520 98.494,160.000 96.092,160.000 95.438 C 160.000 94.862,157.957 94.800,138.976 94.800 C 126.703 94.800,118.045 94.949,118.174 95.158 C 118.471 95.639,117.438 96.000,115.767 96.000 C 115.015 96.000,114.400 96.180,114.400 96.400 C 114.400 96.620,114.031 96.800,113.581 96.800 C 113.130 96.800,112.345 97.250,111.835 97.800 C 111.325 98.350,110.695 98.800,110.435 98.800 C 109.809 98.800,106.200 102.642,105.585 103.963 C 105.320 104.533,104.854 105.478,104.551 106.062 C 103.694 107.712,103.755 295.442,104.613 296.576 C 104.936 297.004,105.200 297.746,105.200 298.227 C 105.200 298.708,105.470 299.326,105.800 299.600 C 106.130 299.874,106.400 300.346,106.400 300.649 C 106.400 300.952,106.542 301.200,106.716 301.200 C 106.890 301.200,107.558 302.100,108.200 303.200 C 108.842 304.300,109.497 305.200,109.656 305.200 C 109.814 305.200,110.604 305.824,111.413 306.586 C 112.221 307.349,113.224 308.081,113.641 308.213 C 114.059 308.346,114.400 308.622,114.400 308.827 C 114.400 309.032,114.805 309.206,115.300 309.213 C 115.795 309.220,116.549 309.490,116.976 309.813 C 117.404 310.136,118.079 310.400,118.476 310.400 C 118.874 310.400,119.200 310.580,119.200 310.800 C 119.200 311.065,143.867 311.200,192.400 311.200 C 240.933 311.200,265.600 311.065,265.600 310.800 C 265.600 310.580,266.127 310.400,266.771 310.400 C 267.416 310.400,268.213 310.130,268.543 309.800 C 268.873 309.470,269.336 309.200,269.571 309.200 C 269.807 309.200,270.000 309.020,270.000 308.800 C 270.000 308.580,270.366 308.400,270.813 308.400 C 271.259 308.400,271.729 308.130,271.855 307.800 C 271.982 307.470,272.336 307.200,272.643 307.200 C 272.949 307.200,273.200 307.045,273.200 306.856 C 273.200 306.667,273.830 305.844,274.600 305.027 C 275.370 304.211,276.006 303.331,276.013 303.072 C 276.020 302.812,276.296 302.243,276.626 301.806 C 278.976 298.696,278.839 304.695,278.809 206.253 C 278.782 116.704,278.818 114.000,280.041 114.000 C 280.477 114.000,290.112 104.337,290.909 103.100 C 291.778 101.753,293.098 101.647,293.405 102.900 C 293.526 103.395,293.673 114.909,293.730 128.486 L 293.835 153.172 294.787 154.186 C 295.311 154.744,295.981 155.200,296.275 155.200 C 296.787 155.200,298.379 155.964,298.800 156.413 C 298.910 156.530,300.170 157.211,301.600 157.926 C 303.030 158.642,304.470 159.392,304.800 159.594 C 305.130 159.795,306.930 160.705,308.800 161.615 C 312.409 163.372,313.676 164.057,314.000 164.430 C 314.110 164.556,315.280 165.199,316.600 165.859 C 319.998 167.557,327.723 171.650,328.200 172.006 C 328.420 172.170,331.117 173.597,334.192 175.178 C 337.268 176.759,339.880 178.206,339.996 178.394 C 340.113 178.583,340.703 178.861,341.308 179.013 C 341.913 179.164,342.506 179.449,342.627 179.644 C 342.748 179.840,343.197 180.000,343.624 180.000 C 344.051 180.000,344.400 180.178,344.400 180.396 C 344.400 180.889,350.524 184.000,351.495 184.000 C 351.887 184.000,352.432 184.360,352.707 184.800 C 352.982 185.240,353.410 185.600,353.659 185.600 C 353.908 185.600,354.989 186.140,356.062 186.800 C 357.134 187.460,358.245 188.000,358.531 188.000 C 358.816 188.000,359.408 188.315,359.847 188.700 C 361.019 189.729,365.598 191.974,367.100 192.256 C 367.815 192.390,368.400 192.741,368.400 193.035 C 368.400 193.329,369.705 194.215,371.300 195.003 C 375.592 197.123,381.746 200.378,385.600 202.566 C 390.514 205.357,395.794 208.000,396.453 208.000 C 396.766 208.000,397.330 208.360,397.707 208.800 C 398.653 209.904,399.534 209.801,399.849 208.549 C 400.318 206.678,399.626 181.313,398.965 176.200 C 398.823 175.100,398.727 173.785,398.751 173.278 C 398.775 172.771,398.661 172.439,398.497 172.540 C 398.334 172.641,398.208 172.066,398.217 171.262 C 398.226 170.458,398.046 169.668,397.817 169.506 C 397.554 169.321,397.603 169.210,397.949 169.206 C 398.362 169.202,398.388 169.068,398.053 168.664 C 397.809 168.370,397.536 167.425,397.447 166.564 C 397.011 162.335,396.243 158.131,395.774 157.407 C 395.352 156.755,394.714 153.709,394.327 150.500 C 394.294 150.225,394.140 150.000,393.986 150.000 C 393.832 150.000,393.592 149.325,393.454 148.500 C 392.706 144.025,392.471 143.091,392.023 142.814 C 391.753 142.647,391.547 142.396,391.566 142.255 C 391.585 142.115,391.586 141.955,391.569 141.900 C 391.322 141.090,391.083 139.916,390.919 138.702 C 390.807 137.878,390.555 137.304,390.358 137.426 C 390.161 137.548,389.999 137.232,389.998 136.724 C 389.996 136.216,389.726 135.284,389.398 134.654 C 389.069 134.024,388.800 133.138,388.800 132.686 C 388.800 132.233,388.534 131.569,388.210 131.211 C 387.885 130.852,387.548 130.208,387.460 129.779 C 386.917 127.117,386.626 126.308,386.143 126.123 C 385.844 126.008,385.600 125.743,385.600 125.534 C 385.600 125.324,385.825 125.288,386.100 125.453 C 386.485 125.685,386.495 125.621,386.141 125.177 C 385.889 124.860,385.456 123.835,385.178 122.900 C 384.900 121.965,384.511 121.200,384.313 121.200 C 384.115 121.200,384.058 121.029,384.188 120.820 C 384.317 120.611,384.097 120.266,383.699 120.053 C 383.270 119.823,382.935 119.134,382.876 118.361 C 382.821 117.643,382.378 116.413,381.891 115.628 C 381.404 114.843,381.049 114.065,381.102 113.900 C 381.156 113.735,380.930 113.600,380.600 113.600 C 380.270 113.600,380.000 113.409,380.000 113.176 C 380.000 112.943,380.163 112.854,380.363 112.977 C 380.562 113.100,380.631 112.841,380.516 112.401 C 380.401 111.960,380.058 111.600,379.753 111.600 C 379.430 111.600,379.200 111.185,379.200 110.600 C 379.200 110.050,378.840 109.240,378.400 108.800 C 377.960 108.360,377.600 107.640,377.600 107.200 C 377.600 106.760,377.420 106.400,377.200 106.400 C 376.980 106.400,376.800 106.074,376.800 105.675 C 376.800 105.277,376.485 104.595,376.100 104.160 C 375.715 103.725,375.345 103.106,375.278 102.784 C 375.211 102.463,374.893 101.998,374.571 101.751 C 374.249 101.504,373.702 100.469,373.355 99.451 C 373.009 98.433,372.477 97.600,372.175 97.600 C 371.861 97.600,371.720 97.353,371.846 97.024 C 371.970 96.702,371.717 96.230,371.273 95.953 C 370.837 95.680,370.574 95.212,370.689 94.912 C 370.810 94.597,370.674 94.416,370.367 94.484 C 369.868 94.593,369.773 94.403,369.650 93.047 C 369.623 92.742,369.240 92.399,368.800 92.284 C 368.239 92.137,367.998 91.735,367.994 90.937 C 367.990 90.200,367.874 89.980,367.663 90.312 C 367.435 90.671,367.109 90.373,366.569 89.312 C 366.146 88.480,365.642 87.685,365.449 87.545 C 365.256 87.404,365.224 87.085,365.378 86.835 C 365.541 86.571,365.437 86.426,365.130 86.490 C 364.838 86.551,364.645 86.375,364.700 86.100 C 364.755 85.825,364.609 85.600,364.376 85.600 C 364.143 85.600,364.065 85.419,364.202 85.197 C 364.339 84.976,364.170 84.687,363.828 84.555 C 363.485 84.424,363.304 84.155,363.426 83.958 C 363.548 83.761,363.277 83.600,362.824 83.600 C 362.371 83.600,362.000 83.358,362.000 83.061 C 362.000 82.765,361.634 82.100,361.187 81.585 C 360.739 81.069,360.464 80.411,360.574 80.123 C 360.685 79.836,360.511 79.600,360.187 79.600 C 359.852 79.600,359.600 79.229,359.600 78.733 C 359.600 78.257,359.489 77.978,359.352 78.114 C 359.012 78.455,358.164 77.548,357.826 76.481 C 357.672 75.997,357.278 75.600,356.949 75.600 C 356.621 75.600,356.450 75.443,356.569 75.250 C 356.688 75.058,356.338 74.565,355.792 74.155 C 355.247 73.746,354.800 73.082,354.800 72.681 C 354.800 72.281,354.665 72.035,354.500 72.134 C 354.335 72.234,353.968 72.065,353.684 71.758 C 353.401 71.451,353.272 71.200,353.398 71.200 C 353.525 71.200,353.435 70.840,353.200 70.400 C 352.965 69.960,352.495 69.600,352.157 69.600 C 351.529 69.600,350.400 68.684,350.400 68.174 C 350.400 68.019,349.950 67.475,349.400 66.965 C 348.369 66.009,348.046 65.334,348.862 65.838 C 349.141 66.011,349.215 65.948,349.049 65.679 C 348.898 65.435,348.486 65.346,348.133 65.481 C 347.697 65.648,347.551 65.548,347.678 65.167 C 347.905 64.485,347.087 63.600,346.229 63.600 C 345.883 63.600,345.600 63.330,345.600 63.000 C 345.600 62.670,345.319 62.400,344.976 62.400 C 344.633 62.400,344.464 62.220,344.600 62.000 C 344.736 61.780,344.657 61.600,344.424 61.600 C 344.191 61.600,344.045 61.386,344.100 61.124 C 344.155 60.862,343.853 60.572,343.428 60.481 C 343.004 60.389,342.406 60.063,342.100 59.757 C 341.566 59.223,341.748 59.014,342.600 59.186 C 342.820 59.230,342.850 59.117,342.667 58.933 C 342.346 58.613,342.202 58.568,341.100 58.444 C 340.752 58.405,340.782 58.270,341.200 58.000 C 341.668 57.698,341.559 57.611,340.705 57.606 C 339.809 57.601,339.627 57.436,339.705 56.700 C 339.780 55.991,339.572 55.774,338.722 55.676 C 337.975 55.589,337.712 55.374,337.865 54.976 C 338.014 54.587,337.812 54.400,337.243 54.400 C 336.779 54.400,336.378 54.220,336.350 54.000 C 336.322 53.780,336.278 53.375,336.250 53.100 C 336.223 52.825,335.795 52.542,335.300 52.472 C 334.805 52.402,334.400 52.166,334.400 51.949 C 334.400 51.731,334.608 51.681,334.862 51.838 C 335.150 52.016,335.215 51.948,335.034 51.655 C 334.875 51.398,334.563 51.299,334.342 51.436 C 333.882 51.720,332.320 50.213,332.691 49.843 C 332.824 49.709,332.524 49.600,332.024 49.600 C 331.380 49.600,331.182 49.425,331.345 49.000 C 331.472 48.667,331.356 48.400,331.082 48.400 C 330.812 48.400,330.252 47.950,329.839 47.400 C 329.426 46.850,328.843 46.400,328.544 46.400 C 328.245 46.400,328.000 46.147,328.000 45.837 C 328.000 45.465,327.719 45.348,327.170 45.492 C 326.521 45.662,326.368 45.544,326.470 44.955 C 326.546 44.514,326.392 44.242,326.100 44.300 C 325.825 44.355,325.600 44.220,325.600 44.000 C 325.600 43.780,325.330 43.600,325.000 43.600 C 324.670 43.600,324.400 43.330,324.400 43.000 C 324.400 42.667,324.044 42.400,323.600 42.400 C 323.160 42.400,322.845 42.175,322.900 41.900 C 322.955 41.625,322.707 41.448,322.348 41.506 C 321.967 41.569,321.605 41.262,321.475 40.766 C 321.353 40.299,321.062 40.038,320.827 40.183 C 320.592 40.328,320.400 40.257,320.400 40.024 C 320.400 39.791,319.950 39.600,319.400 39.600 C 318.778 39.600,318.400 39.373,318.400 39.000 C 318.400 38.670,318.136 38.400,317.813 38.400 C 317.468 38.400,317.316 38.164,317.444 37.829 C 317.604 37.412,317.439 37.317,316.832 37.476 C 316.243 37.630,316.000 37.505,316.000 37.047 C 316.000 36.645,315.660 36.398,315.100 36.394 C 314.372 36.389,314.315 36.314,314.800 36.000 C 315.420 35.599,315.113 35.456,313.900 35.579 C 313.502 35.620,313.200 35.381,313.200 35.025 C 313.200 34.681,312.930 34.400,312.600 34.400 C 312.270 34.400,312.000 34.127,312.000 33.792 C 312.000 33.345,311.738 33.251,311.004 33.435 C 310.294 33.613,309.936 33.500,309.761 33.042 C 309.625 32.689,309.264 32.400,308.957 32.400 C 308.651 32.400,308.400 32.130,308.400 31.800 C 308.400 31.470,308.175 31.245,307.900 31.300 C 307.625 31.355,307.445 31.175,307.500 30.900 C 307.559 30.607,307.187 30.400,306.600 30.400 C 306.013 30.400,305.641 30.193,305.700 29.900 C 305.755 29.625,305.455 29.399,305.033 29.398 C 304.611 29.397,304.191 29.172,304.099 28.898 C 304.008 28.624,303.504 28.400,302.979 28.400 C 302.254 28.400,302.086 28.240,302.280 27.736 C 302.482 27.209,302.356 27.118,301.667 27.298 C 301.081 27.452,300.800 27.343,300.800 26.963 C 300.800 26.629,300.393 26.400,299.800 26.400 C 299.172 26.400,298.800 26.174,298.800 25.792 C 298.800 25.334,298.538 25.250,297.734 25.452 C 296.881 25.666,296.715 25.598,296.903 25.110 C 297.160 24.440,295.578 23.450,294.200 23.418 C 293.760 23.408,293.445 23.175,293.500 22.900 C 293.565 22.574,293.098 22.400,292.157 22.400 C 291.012 22.400,290.764 22.271,290.955 21.774 C 291.136 21.301,291.010 21.207,290.440 21.387 C 290.007 21.525,289.422 21.365,289.071 21.014 C 288.733 20.676,288.084 20.400,287.629 20.400 C 287.173 20.400,286.800 20.209,286.800 19.976 C 286.800 19.743,286.980 19.664,287.200 19.800 C 287.420 19.936,287.600 19.836,287.600 19.577 C 287.600 19.296,287.262 19.195,286.761 19.326 C 285.749 19.591,284.719 19.254,285.026 18.758 C 285.148 18.561,284.562 18.386,283.724 18.368 C 282.886 18.351,282.425 18.246,282.700 18.135 C 283.579 17.781,283.236 17.104,282.297 17.340 C 281.800 17.465,281.125 17.397,280.797 17.189 C 280.469 16.982,280.380 16.802,280.600 16.790 C 280.820 16.778,280.285 16.411,279.411 15.975 C 278.537 15.539,277.605 15.266,277.340 15.368 C 277.075 15.469,276.643 15.293,276.380 14.976 C 276.117 14.659,275.463 14.400,274.927 14.400 C 274.391 14.400,274.052 14.239,274.174 14.042 C 274.444 13.606,273.477 13.200,272.167 13.200 C 271.635 13.200,271.200 13.020,271.200 12.800 C 271.200 12.580,270.491 12.400,269.624 12.400 C 268.757 12.400,267.937 12.222,267.803 12.005 C 267.658 11.770,267.837 11.716,268.245 11.873 C 268.734 12.060,268.841 11.991,268.619 11.630 C 268.439 11.339,267.871 11.208,267.278 11.321 C 266.065 11.553,265.113 11.264,265.426 10.758 C 265.653 10.390,264.887 10.256,263.300 10.384 C 262.805 10.424,262.400 10.254,262.400 10.005 C 262.400 9.756,262.608 9.681,262.862 9.838 C 263.148 10.015,263.215 9.948,263.038 9.662 C 262.881 9.408,262.144 9.200,261.400 9.200 C 260.656 9.200,259.936 9.020,259.800 8.800 C 259.664 8.580,258.798 8.387,257.876 8.372 C 256.649 8.351,256.412 8.261,256.993 8.034 C 258.001 7.640,255.184 7.024,254.039 7.388 C 253.629 7.518,253.093 7.353,252.807 7.009 C 252.494 6.631,251.629 6.400,250.527 6.400 C 249.538 6.400,248.854 6.236,248.982 6.029 C 249.295 5.522,248.121 5.201,246.223 5.274 C 245.324 5.309,244.578 5.134,244.489 4.868 C 244.393 4.579,243.389 4.398,241.867 4.394 C 240.366 4.390,239.609 4.255,239.934 4.050 C 240.716 3.553,239.576 3.200,237.191 3.200 C 236.122 3.200,235.136 3.020,235.000 2.800 C 234.863 2.579,233.063 2.400,230.976 2.400 C 227.593 2.400,226.298 2.031,227.700 1.465 C 227.975 1.354,226.481 1.249,224.380 1.232 C 222.279 1.214,220.389 1.029,220.179 0.819 C 219.675 0.315,191.857 -0.032,186.400 0.397 M311.400 56.000 C 311.536 56.220,312.142 56.400,312.746 56.400 C 318.568 56.400,319.518 65.556,314.206 70.467 C 313.413 71.200,311.786 72.745,310.591 73.900 C 307.964 76.438,307.670 76.462,305.614 74.300 C 301.994 70.492,299.031 67.600,298.751 67.600 C 298.588 67.600,298.340 67.242,298.202 66.805 C 297.923 65.927,299.097 63.600,299.819 63.600 C 300.064 63.600,300.506 63.150,300.800 62.600 C 301.094 62.050,301.575 61.600,301.868 61.600 C 302.160 61.600,302.400 61.434,302.400 61.232 C 302.400 61.029,303.120 60.136,304.000 59.247 C 304.880 58.358,305.600 57.460,305.600 57.251 C 305.600 57.042,306.319 56.749,307.198 56.600 C 308.077 56.452,308.897 56.166,309.022 55.965 C 309.325 55.474,311.091 55.499,311.400 56.000 M297.449 76.538 C 302.051 81.127,302.677 82.200,301.386 83.284 C 301.048 83.568,300.521 84.025,300.215 84.300 C 299.908 84.575,299.493 84.800,299.293 84.800 C 299.092 84.800,298.723 85.250,298.473 85.800 C 298.222 86.350,297.743 86.800,297.409 86.800 C 297.074 86.800,296.800 86.971,296.800 87.181 C 296.800 87.749,289.843 94.800,289.283 94.800 C 289.017 94.800,288.800 94.998,288.800 95.240 C 288.800 95.803,240.583 144.000,240.020 144.000 C 239.789 144.000,239.600 144.196,239.600 144.435 C 239.600 145.014,232.629 152.000,232.052 152.000 C 231.803 152.000,231.600 152.196,231.600 152.435 C 231.600 153.014,224.629 160.000,224.052 160.000 C 223.803 160.000,223.600 160.196,223.600 160.435 C 223.600 161.014,216.629 168.000,216.052 168.000 C 215.803 168.000,215.600 168.199,215.600 168.443 C 215.600 168.686,213.532 170.949,211.005 173.471 C 206.158 178.310,205.065 178.861,204.205 176.900 C 203.988 176.405,203.621 176.000,203.389 176.000 C 202.878 176.000,200.000 172.931,200.000 172.386 C 200.000 172.174,199.643 172.000,199.208 172.000 C 198.696 172.000,198.326 171.646,198.164 171.000 C 198.026 170.450,197.659 170.000,197.348 170.000 C 196.370 170.000,195.786 168.147,196.402 166.997 C 196.695 166.448,197.175 166.000,197.468 166.000 C 197.760 166.000,198.000 165.815,198.000 165.589 C 198.000 165.053,205.053 158.000,205.589 158.000 C 205.815 158.000,206.000 157.810,206.000 157.578 C 206.000 157.057,213.099 150.000,213.622 150.000 C 213.830 150.000,214.000 149.823,214.000 149.606 C 214.000 149.111,259.540 103.600,260.036 103.600 C 260.236 103.600,260.400 103.448,260.400 103.263 C 260.400 103.078,261.570 101.733,263.000 100.275 C 264.430 98.816,265.600 97.438,265.600 97.212 C 265.600 96.985,265.785 96.800,266.011 96.800 C 266.237 96.800,268.470 94.730,270.975 92.200 C 273.479 89.670,275.724 87.600,275.964 87.600 C 276.204 87.600,276.400 87.430,276.400 87.221 C 276.400 86.852,283.423 79.600,283.781 79.600 C 284.089 79.600,286.800 76.695,286.800 76.366 C 286.800 76.194,287.163 75.939,287.606 75.798 C 288.049 75.657,288.321 75.395,288.209 75.215 C 288.098 75.035,288.500 74.567,289.103 74.176 C 289.707 73.784,290.435 73.135,290.723 72.732 C 291.744 71.302,292.795 71.897,297.449 76.538 M146.124 121.688 C 148.232 123.189,148.400 124.198,148.400 135.327 C 148.400 145.461,148.118 148.000,146.994 148.000 C 146.704 148.000,146.392 148.225,146.300 148.500 C 145.917 149.654,122.800 149.474,122.800 148.317 C 122.800 148.143,122.544 148.000,122.231 148.000 C 121.027 148.000,120.657 145.186,120.573 135.400 C 120.475 123.904,120.990 121.600,123.661 121.600 C 124.068 121.600,124.400 121.417,124.400 121.193 C 124.400 120.287,144.809 120.752,146.124 121.688 M125.802 127.600 C 125.505 127.930,125.202 129.280,125.131 130.600 L 125.000 133.000 126.200 132.862 C 126.860 132.786,127.460 132.561,127.533 132.362 C 127.782 131.686,128.607 131.996,129.405 133.064 C 131.449 135.801,132.588 136.675,133.252 136.018 C 134.705 134.582,138.399 127.232,137.697 127.176 C 133.436 126.836,126.260 127.092,125.802 127.600 M139.956 133.900 C 139.430 134.945,138.888 135.890,138.750 136.000 C 138.613 136.110,138.379 136.761,138.230 137.446 C 138.082 138.131,137.648 139.031,137.267 139.446 C 136.886 139.861,136.149 140.894,135.628 141.743 C 134.405 143.737,132.769 143.619,130.740 141.392 C 125.091 135.188,124.733 135.123,125.092 140.352 L 125.315 143.616 133.358 143.508 L 141.400 143.400 141.511 137.700 C 141.631 131.523,141.416 130.997,139.956 133.900 M126.800 156.400 C 126.800 157.034,143.870 156.935,144.167 156.300 C 144.353 155.900,144.447 155.900,144.633 156.300 C 144.762 156.575,145.077 156.806,145.333 156.813 C 147.844 156.885,148.379 159.339,148.390 170.850 C 148.401 181.273,148.244 182.811,147.139 183.100 C 146.733 183.206,146.400 183.452,146.400 183.647 C 146.400 183.843,141.161 184.000,134.600 184.000 C 127.568 184.000,122.800 183.849,122.800 183.627 C 122.800 183.422,122.456 183.145,122.036 183.011 C 121.252 182.763,120.365 180.028,120.411 178.000 C 120.423 177.450,120.487 173.130,120.553 168.400 C 120.695 158.148,121.123 156.800,124.232 156.800 C 124.545 156.800,124.800 156.620,124.800 156.400 C 124.800 156.180,125.250 156.000,125.800 156.000 C 126.350 156.000,126.800 156.180,126.800 156.400 M125.406 161.981 C 125.140 162.818,125.038 167.572,125.281 167.814 C 125.361 167.894,125.871 167.736,126.413 167.462 C 127.688 166.819,128.846 167.426,131.825 170.300 C 133.064 171.496,133.769 170.831,135.942 166.414 C 137.120 164.019,137.965 161.867,137.819 161.630 C 137.273 160.747,125.694 161.074,125.406 161.981 M140.772 167.456 C 140.427 167.865,139.527 169.460,138.772 171.000 C 138.018 172.540,137.175 174.038,136.900 174.329 C 136.625 174.619,136.400 174.992,136.400 175.157 C 136.400 175.321,135.860 176.061,135.200 176.800 C 133.739 178.436,133.703 178.800,135.000 178.800 C 135.550 178.800,136.000 178.620,136.000 178.400 C 136.000 178.180,136.450 178.000,137.000 178.000 C 137.550 178.000,138.000 178.180,138.000 178.400 C 138.000 179.045,139.998 178.859,140.709 178.149 C 141.213 177.644,141.397 176.449,141.526 172.836 C 141.733 167.030,141.647 166.418,140.772 167.456 M125.082 171.067 C 124.786 171.546,125.050 177.034,125.396 177.594 C 125.534 177.817,126.087 178.000,126.624 178.000 C 127.161 178.000,127.600 178.180,127.600 178.400 C 127.600 178.620,127.870 178.800,128.200 178.800 C 128.530 178.800,128.800 178.620,128.800 178.400 C 128.800 178.180,129.250 178.000,129.800 178.000 C 130.350 178.000,130.800 178.180,130.800 178.400 C 130.800 178.878,133.065 178.942,133.355 178.473 C 133.466 178.293,133.179 177.888,132.716 177.573 C 131.555 176.781,129.600 174.754,129.600 174.341 C 129.600 174.153,129.243 174.000,128.808 174.000 C 128.296 174.000,127.926 173.646,127.764 173.000 C 127.626 172.450,127.238 172.000,126.901 172.000 C 126.564 172.000,126.071 171.703,125.805 171.339 C 125.531 170.965,125.218 170.847,125.082 171.067 M192.000 178.200 C 192.000 178.530,192.340 178.800,192.757 178.800 C 193.230 178.800,193.607 179.174,193.764 179.800 C 193.902 180.350,194.275 180.800,194.594 180.800 C 194.912 180.800,195.365 181.160,195.600 181.600 C 196.233 182.784,195.451 184.000,194.056 184.000 C 193.382 184.000,192.567 184.397,192.000 185.000 C 191.483 185.550,190.816 186.000,190.516 186.000 C 189.935 186.000,187.964 187.150,187.552 187.730 C 187.416 187.922,186.966 188.015,186.552 187.936 C 185.452 187.727,185.345 185.625,186.377 184.516 C 186.825 184.036,187.669 182.598,188.252 181.321 C 189.649 178.264,192.000 176.306,192.000 178.200 M135.588 190.800 C 141.836 190.800,143.750 190.926,144.654 191.398 C 145.284 191.726,146.085 191.996,146.432 191.998 C 148.207 192.004,148.648 195.348,148.381 206.800 C 148.074 220.023,148.984 219.200,134.662 219.200 C 128.851 219.200,124.349 219.041,124.219 218.831 C 124.094 218.628,123.463 218.346,122.818 218.204 C 120.879 217.778,120.663 216.375,120.676 204.282 C 120.687 194.224,120.735 193.522,121.456 192.882 C 122.748 191.734,124.670 190.800,125.738 190.800 C 126.296 190.800,126.886 190.584,127.050 190.320 C 127.281 189.946,127.382 189.946,127.507 190.320 C 127.624 190.672,129.780 190.800,135.588 190.800 M125.765 195.756 C 125.194 196.375,124.648 202.800,125.167 202.800 C 125.379 202.800,125.664 202.620,125.800 202.400 C 126.690 200.961,132.000 203.688,132.000 205.584 C 132.000 206.580,133.542 205.941,133.948 204.777 C 134.183 204.104,134.920 202.745,135.587 201.757 C 136.254 200.769,136.801 199.744,136.801 199.480 C 136.802 199.216,137.175 198.389,137.630 197.643 C 138.390 196.396,138.405 196.234,137.814 195.643 C 137.263 195.092,137.120 195.082,136.816 195.574 C 136.533 196.031,136.341 196.049,135.873 195.661 C 135.087 195.008,126.380 195.090,125.765 195.756 M233.505 200.760 C 233.887 200.958,235.789 201.325,237.731 201.576 C 239.673 201.827,241.563 202.197,241.931 202.398 C 242.299 202.600,243.680 203.051,245.000 203.400 C 246.320 203.750,247.940 204.280,248.600 204.579 C 249.260 204.878,250.295 205.316,250.900 205.553 L 252.000 205.983 252.000 213.791 L 252.000 221.600 250.556 221.600 C 249.450 221.600,248.652 221.216,247.156 219.963 C 245.280 218.392,237.278 214.003,236.282 213.998 C 236.017 213.996,235.309 213.739,234.708 213.425 C 231.481 211.742,222.104 211.856,218.446 213.623 C 217.562 214.050,216.647 214.400,216.412 214.400 C 215.468 214.400,210.854 219.541,210.431 221.064 C 208.236 228.967,213.098 235.566,222.600 237.580 C 223.920 237.860,225.180 238.222,225.400 238.385 C 225.620 238.548,227.400 238.993,229.356 239.372 C 231.312 239.752,233.202 240.216,233.556 240.402 C 233.910 240.588,235.476 241.029,237.036 241.381 C 239.997 242.050,245.482 244.642,247.200 246.185 C 247.750 246.679,248.500 247.188,248.866 247.316 C 249.232 247.444,249.772 247.985,250.066 248.518 C 250.360 249.052,251.260 250.458,252.066 251.644 C 252.935 252.921,253.737 254.745,254.034 256.118 C 254.310 257.393,254.685 258.529,254.868 258.642 C 255.310 258.915,255.297 269.333,254.854 269.820 C 254.664 270.029,254.296 271.100,254.037 272.200 C 252.870 277.144,246.531 286.000,244.159 286.000 C 243.852 286.000,243.600 286.180,243.600 286.400 C 243.600 286.620,243.423 286.800,243.206 286.800 C 242.989 286.800,241.954 287.318,240.906 287.952 C 239.858 288.586,238.010 289.329,236.800 289.604 C 235.590 289.880,234.347 290.306,234.038 290.552 C 233.241 291.188,213.671 291.171,212.360 290.533 C 211.832 290.277,210.230 289.856,208.800 289.599 C 207.370 289.341,205.660 288.883,205.000 288.581 C 204.340 288.279,202.900 287.736,201.800 287.375 C 200.700 287.013,198.767 286.241,197.504 285.659 L 195.208 284.600 195.204 276.700 L 195.200 268.800 196.647 268.800 C 198.012 268.800,199.113 269.465,201.634 271.810 C 201.982 272.135,202.415 272.400,202.596 272.400 C 202.777 272.400,203.481 272.820,204.162 273.334 C 205.581 274.404,209.846 276.492,212.200 277.268 C 213.080 277.558,213.890 277.905,214.000 278.039 C 214.229 278.319,218.348 279.055,221.630 279.403 C 229.128 280.199,238.448 276.327,239.848 271.835 C 239.991 271.376,240.309 270.872,240.554 270.715 C 241.141 270.339,241.163 262.081,240.577 261.686 C 240.345 261.529,239.915 260.809,239.623 260.086 C 238.990 258.521,235.888 255.682,234.433 255.336 C 233.865 255.200,233.192 254.927,232.938 254.728 C 232.685 254.529,231.335 254.091,229.938 253.756 C 228.542 253.420,227.040 252.987,226.600 252.794 C 226.160 252.600,224.360 252.150,222.600 251.793 C 220.840 251.436,219.040 250.991,218.600 250.804 C 218.160 250.617,216.405 250.153,214.700 249.773 C 212.995 249.392,211.600 248.927,211.600 248.740 C 211.600 248.553,211.319 248.400,210.975 248.400 C 207.287 248.400,199.267 240.875,197.547 235.800 C 197.248 234.920,196.823 234.072,196.602 233.915 C 196.024 233.505,196.074 219.990,196.658 218.762 C 196.909 218.233,197.789 216.386,198.613 214.659 C 200.157 211.418,204.212 206.800,206.669 205.483 C 212.485 202.365,215.578 201.207,218.100 201.202 C 218.705 201.201,219.200 201.020,219.200 200.800 C 219.200 200.292,232.530 200.255,233.505 200.760 M140.803 201.902 C 140.016 202.787,137.600 207.606,137.600 208.290 C 137.600 208.584,137.343 208.924,137.028 209.045 C 136.577 209.218,135.600 211.144,135.600 211.860 C 135.600 211.937,136.926 212.000,138.547 212.000 L 141.494 212.000 141.548 206.600 C 141.578 203.630,141.556 201.207,141.501 201.215 C 141.445 201.224,141.132 201.533,140.803 201.902 M125.004 208.300 C 125.444 212.172,125.276 212.000,128.627 212.000 C 130.262 212.000,131.600 211.912,131.600 211.805 C 131.600 211.355,130.182 210.000,129.711 210.000 C 129.430 210.000,129.200 209.829,129.200 209.621 C 129.200 209.082,127.532 207.389,126.700 207.083 C 126.315 206.941,126.000 206.639,126.000 206.413 C 126.000 206.186,125.717 206.000,125.371 206.000 C 124.842 206.000,124.784 206.365,125.004 208.300 M397.714 223.800 C 397.717 224.900,397.795 225.303,397.887 224.695 C 397.979 224.086,397.977 223.186,397.882 222.695 C 397.787 222.203,397.711 222.700,397.714 223.800 M128.000 225.600 C 128.000 225.853,130.933 226.000,136.000 226.000 C 141.067 226.000,144.000 225.853,144.000 225.600 C 144.000 225.380,144.270 225.200,144.600 225.200 C 144.930 225.200,145.200 225.380,145.200 225.600 C 145.200 225.820,145.380 226.000,145.600 226.000 C 146.207 226.000,147.584 227.506,148.016 228.642 C 148.576 230.116,148.514 249.833,147.946 250.926 C 147.318 252.134,146.148 253.200,145.450 253.200 C 145.129 253.200,144.762 253.425,144.633 253.700 C 144.447 254.100,144.353 254.100,144.167 253.700 C 143.871 253.066,128.000 252.967,128.000 253.600 C 128.000 253.820,127.100 254.000,126.000 254.000 C 124.900 254.000,124.000 253.820,124.000 253.600 C 124.000 253.380,123.721 253.200,123.381 253.200 C 122.061 253.200,120.802 251.198,120.766 249.042 C 120.722 246.404,120.722 230.073,120.766 228.916 C 120.806 227.873,122.688 226.000,123.696 226.000 C 124.083 226.000,124.400 225.820,124.400 225.600 C 124.400 225.380,125.210 225.200,126.200 225.200 C 127.190 225.200,128.000 225.380,128.000 225.600 M125.576 230.845 C 125.003 231.916,125.028 245.511,125.605 246.205 C 126.008 246.692,127.434 246.800,133.459 246.800 L 140.820 246.800 141.210 245.774 C 141.685 244.525,141.722 231.612,141.253 230.872 C 140.702 230.003,126.040 229.977,125.576 230.845 M395.600 236.200 C 395.600 236.750,395.780 237.200,396.000 237.200 C 396.220 237.200,396.400 236.750,396.400 236.200 C 396.400 235.650,396.220 235.200,396.000 235.200 C 395.780 235.200,395.600 235.650,395.600 236.200 M385.600 265.000 C 385.600 265.550,385.780 266.000,386.000 266.000 C 386.220 266.000,386.400 265.550,386.400 265.000 C 386.400 264.450,386.220 264.000,386.000 264.000 C 385.780 264.000,385.600 264.450,385.600 265.000 M373.606 297.300 C 373.611 298.028,373.686 298.085,374.000 297.600 C 374.501 296.824,374.501 296.400,374.000 296.400 C 373.780 296.400,373.603 296.805,373.606 297.300 M372.273 300.261 C 371.862 300.672,371.945 302.400,372.376 302.400 C 372.583 302.400,372.881 302.192,373.038 301.938 C 373.215 301.652,373.148 301.585,372.862 301.762 C 372.608 301.919,372.400 301.872,372.400 301.657 C 372.400 301.442,372.574 301.207,372.787 301.133 C 373.000 301.060,373.033 300.772,372.860 300.494 C 372.687 300.216,372.423 300.111,372.273 300.261 ",
                    fill: '#f5880d',
                    stroke: 'none',
                    'fill-rule': 'evenodd'
                }
            ),
            el(
                'path',
                { 
                    d: "M310.701 56.766 C 313.124 57.069,313.966 57.512,315.707 59.400 C 316.442 60.196,316.443 60.196,316.023 59.328 C 315.220 57.667,313.242 56.648,310.626 56.547 L 308.200 56.454 310.701 56.766 M304.383 59.480 L 302.600 61.361 304.400 59.805 C 306.030 58.396,306.722 57.600,306.317 57.600 C 306.234 57.600,305.364 58.446,304.383 59.480 M316.785 61.634 C 316.981 62.385,317.239 63.360,317.358 63.800 C 317.476 64.240,317.480 63.790,317.366 62.800 C 317.252 61.810,316.995 60.835,316.794 60.634 C 316.573 60.413,316.569 60.809,316.785 61.634 M298.400 65.998 C 298.400 66.164,299.840 67.763,301.600 69.551 C 303.360 71.340,304.800 72.680,304.800 72.529 C 304.800 72.378,303.360 70.779,301.600 68.976 C 299.840 67.173,298.400 65.833,298.400 65.998 M314.500 68.781 C 313.345 70.062,312.400 71.200,312.400 71.308 C 312.400 71.628,315.655 68.283,316.301 67.300 C 317.230 65.886,316.766 66.267,314.500 68.781 M309.903 73.486 L 308.017 75.373 306.608 74.008 C 305.834 73.257,305.200 72.782,305.200 72.952 C 305.200 73.374,307.457 75.603,307.869 75.588 C 308.228 75.576,310.138 73.871,311.362 72.471 C 312.692 70.951,311.859 71.530,309.903 73.486 M290.062 73.836 C 289.326 74.618,288.799 75.332,288.890 75.423 C 288.980 75.514,289.663 74.961,290.406 74.194 C 292.229 72.313,292.048 72.232,296.907 77.107 C 301.970 82.186,301.818 81.533,298.700 84.789 L 296.200 87.400 298.910 84.801 C 302.207 81.641,302.332 82.180,297.058 76.816 C 292.246 71.922,291.973 71.806,290.062 73.836 M170.400 74.200 C 169.134 74.924,169.357 74.927,171.600 74.221 C 172.877 73.818,173.110 73.650,172.400 73.641 C 171.850 73.634,170.950 73.886,170.400 74.200 M212.033 74.135 C 212.419 74.447,215.600 75.577,215.600 75.402 C 215.600 75.163,212.851 74.000,212.284 74.000 C 212.055 74.000,211.942 74.061,212.033 74.135 M165.322 76.900 C 164.494 77.615,163.392 78.695,162.873 79.300 C 162.354 79.905,161.630 80.414,161.264 80.432 C 160.788 80.454,160.753 80.524,161.141 80.679 C 161.450 80.802,162.649 79.954,163.941 78.697 C 165.183 77.489,166.560 76.303,167.000 76.062 C 167.440 75.821,167.581 75.619,167.314 75.612 C 167.047 75.605,166.150 76.185,165.322 76.900 M218.660 78.186 C 220.112 79.624,221.449 80.800,221.631 80.800 C 222.011 80.800,217.498 76.399,216.608 75.900 C 216.284 75.719,217.208 76.748,218.660 78.186 M286.829 77.029 C 286.099 77.802,285.579 78.512,285.673 78.607 C 285.768 78.701,286.442 78.145,287.171 77.371 C 287.901 76.598,288.421 75.888,288.327 75.793 C 288.232 75.699,287.558 76.255,286.829 77.029 M281.429 82.429 C 279.911 83.954,278.754 85.287,278.857 85.390 C 278.960 85.493,280.284 84.328,281.800 82.800 C 283.316 81.272,284.473 79.940,284.372 79.838 C 284.271 79.737,282.946 80.903,281.429 82.429 M117.105 81.083 C 117.602 81.179,118.322 81.175,118.705 81.075 C 119.087 80.975,118.680 80.896,117.800 80.901 C 116.920 80.905,116.607 80.987,117.105 81.083 M270.824 82.918 C 269.143 84.889,269.129 84.925,270.557 83.600 C 271.823 82.426,273.118 80.754,272.714 80.818 C 272.651 80.828,271.801 81.773,270.824 82.918 M112.600 81.885 C 112.160 81.991,111.635 82.234,111.434 82.425 C 111.128 82.715,113.220 82.308,114.600 81.808 C 115.185 81.596,113.538 81.660,112.600 81.885 M107.700 83.796 C 106.985 84.107,106.400 84.451,106.400 84.560 C 106.400 84.869,108.774 83.965,109.024 83.561 C 109.305 83.107,109.273 83.113,107.700 83.796 M103.700 86.040 C 101.375 87.686,101.542 87.948,103.900 86.354 C 106.246 84.769,106.213 84.796,105.767 84.818 C 105.565 84.828,104.635 85.378,103.700 86.040 M266.685 86.856 C 265.758 87.766,265.348 88.261,265.774 87.956 C 267.089 87.011,268.995 85.200,268.674 85.200 C 268.506 85.200,267.611 85.945,266.685 86.856 M277.129 86.700 C 276.577 87.305,275.206 88.700,274.082 89.800 C 272.958 90.900,271.451 92.376,270.732 93.080 C 270.014 93.783,269.525 94.458,269.647 94.580 C 269.866 94.800,278.400 86.270,278.400 85.831 C 278.400 85.412,278.144 85.587,277.129 86.700 M98.637 90.267 C 97.162 91.734,95.762 93.309,95.524 93.767 C 95.286 94.225,95.166 94.510,95.257 94.400 C 95.349 94.290,96.844 92.715,98.581 90.900 C 102.368 86.943,102.405 86.517,98.637 90.267 M271.799 111.672 C 258.599 124.912,248.070 135.545,248.400 135.302 C 249.465 134.517,296.248 87.600,295.965 87.600 C 295.873 87.600,284.998 98.432,271.799 111.672 M261.489 91.617 C 259.692 93.224,258.017 94.400,257.522 94.400 C 257.052 94.400,256.778 94.512,256.915 94.648 C 257.530 95.263,259.363 94.184,262.068 91.615 C 265.846 88.026,265.502 88.027,261.489 91.617 M129.100 94.700 C 134.875 94.762,144.325 94.762,150.100 94.700 C 155.875 94.637,151.150 94.586,139.600 94.586 C 128.050 94.586,123.325 94.637,129.100 94.700 M222.122 95.600 C 221.873 96.260,221.739 96.800,221.824 96.800 C 221.910 96.800,222.259 96.260,222.600 95.600 C 222.941 94.940,223.075 94.400,222.898 94.400 C 222.721 94.400,222.372 94.940,222.122 95.600 M231.700 94.700 C 236.265 94.764,243.735 94.764,248.300 94.700 C 252.865 94.635,249.130 94.583,240.000 94.583 C 230.870 94.583,227.135 94.635,231.700 94.700 M261.235 102.641 C 256.964 106.910,253.552 110.486,253.653 110.587 C 253.754 110.688,257.330 107.274,261.600 103.000 C 265.870 98.726,269.281 95.151,269.181 95.054 C 269.082 94.958,265.506 98.372,261.235 102.641 M114.800 95.618 C 114.362 95.915,114.524 95.952,115.400 95.756 C 116.871 95.427,117.190 95.198,116.167 95.206 C 115.745 95.209,115.130 95.395,114.800 95.618 M160.809 96.300 C 160.814 96.465,161.185 97.050,161.633 97.600 L 162.448 98.600 161.814 97.300 C 161.211 96.065,160.789 95.645,160.809 96.300 M108.739 99.300 C 107.534 100.455,107.190 100.833,107.974 100.139 C 108.758 99.446,110.030 98.501,110.800 98.041 C 111.570 97.580,111.914 97.202,111.565 97.201 C 111.215 97.201,109.944 98.145,108.739 99.300 M219.980 99.228 C 219.499 99.903,218.211 101.163,217.117 102.028 C 216.023 102.893,215.262 103.600,215.426 103.600 C 215.819 103.600,218.461 101.602,219.106 100.816 C 220.284 99.382,221.240 98.000,221.054 98.000 C 220.944 98.000,220.461 98.553,219.980 99.228 M91.877 100.677 C 91.500 101.693,91.258 102.591,91.338 102.672 C 91.419 102.752,91.800 101.993,92.185 100.985 C 92.570 99.976,92.812 99.079,92.723 98.990 C 92.635 98.901,92.254 99.660,91.877 100.677 M164.200 100.774 C 165.872 102.542,168.298 104.133,170.000 104.579 C 170.550 104.723,169.892 104.289,168.537 103.615 C 167.183 102.942,165.550 101.793,164.909 101.063 C 164.268 100.333,163.487 99.589,163.172 99.409 C 162.857 99.230,163.320 99.844,164.200 100.774 M291.677 103.544 C 289.077 105.193,279.606 115.463,279.664 116.571 L 279.728 117.800 279.885 116.553 C 280.088 114.945,291.607 103.363,292.617 103.751 C 292.976 103.889,293.138 103.823,292.997 103.595 C 292.702 103.118,292.370 103.105,291.677 103.544 M213.800 104.000 C 213.664 104.220,213.158 104.421,212.676 104.446 C 212.011 104.482,211.967 104.537,212.493 104.674 C 212.873 104.774,213.589 104.573,214.082 104.228 C 214.575 103.883,214.769 103.600,214.513 103.600 C 214.257 103.600,213.936 103.780,213.800 104.000 M191.600 105.200 L 172.600 105.412 191.400 105.500 C 203.016 105.554,210.429 105.440,210.800 105.200 C 211.130 104.987,211.220 104.852,211.000 104.900 C 210.780 104.949,202.050 105.084,191.600 105.200 M103.293 109.200 C 103.293 109.970,103.375 110.285,103.476 109.900 C 103.576 109.515,103.576 108.885,103.476 108.500 C 103.375 108.115,103.293 108.430,103.293 109.200 M293.397 201.400 C 293.397 252.880,293.443 273.881,293.500 248.068 C 293.557 222.255,293.557 180.135,293.500 154.468 C 293.443 128.801,293.397 149.920,293.397 201.400 M90.197 200.800 C 90.197 251.510,90.243 272.255,90.300 246.900 C 90.357 221.545,90.357 180.055,90.300 154.700 C 90.243 129.345,90.197 150.090,90.197 200.800 M250.226 113.629 C 248.700 115.144,247.530 116.462,247.626 116.556 C 247.722 116.651,249.055 115.494,250.588 113.986 C 252.122 112.477,253.292 111.160,253.188 111.058 C 253.085 110.956,251.752 112.113,250.226 113.629 M103.396 200.000 C 103.396 248.950,103.443 268.975,103.500 244.500 C 103.557 220.025,103.557 179.975,103.500 155.500 C 103.443 131.025,103.396 151.050,103.396 200.000 M243.235 120.642 C 241.164 122.711,239.545 124.478,239.637 124.570 C 239.728 124.662,241.507 123.050,243.589 120.989 C 245.672 118.928,247.291 117.161,247.188 117.062 C 247.085 116.962,245.306 118.573,243.235 120.642 M127.100 121.898 C 128.915 121.972,131.885 121.972,133.700 121.898 C 135.515 121.823,134.030 121.763,130.400 121.763 C 126.770 121.763,125.285 121.823,127.100 121.898 M144.079 121.980 C 145.873 122.329,146.755 123.015,147.446 124.600 C 147.733 125.260,147.976 125.583,147.984 125.319 C 148.043 123.529,145.771 121.564,143.738 121.646 C 142.738 121.686,142.780 121.727,144.079 121.980 M122.105 123.108 C 121.613 123.708,121.208 124.365,121.205 124.567 C 121.202 124.768,121.245 124.857,121.300 124.765 C 121.355 124.672,121.929 124.012,122.575 123.298 C 123.221 122.584,123.581 122.003,123.375 122.008 C 123.169 122.012,122.597 122.507,122.105 123.108 M231.242 132.651 C 226.975 136.923,223.557 140.490,223.645 140.579 C 223.734 140.667,227.304 137.248,231.579 132.979 C 235.855 128.711,239.273 125.144,239.176 125.052 C 239.079 124.960,235.509 128.380,231.242 132.651 M120.973 135.000 C 120.973 140.500,121.030 142.805,121.099 140.123 C 121.168 137.441,121.168 132.941,121.099 130.123 C 121.030 127.305,120.974 129.500,120.973 135.000 M124.880 126.880 C 124.595 127.165,124.428 128.341,124.470 129.780 C 124.529 131.833,124.560 131.927,124.675 130.400 C 124.971 126.478,124.316 126.800,132.008 126.800 C 135.743 126.800,138.800 126.886,138.800 126.990 C 138.800 127.095,138.441 127.770,138.001 128.490 C 137.562 129.211,137.204 129.980,137.206 130.200 C 137.208 130.420,137.657 129.817,138.204 128.861 C 138.751 127.904,139.098 126.959,138.976 126.761 C 138.624 126.192,125.456 126.304,124.880 126.880 M141.557 129.600 C 140.764 130.834,137.761 136.239,136.223 139.200 C 134.048 143.387,133.962 143.383,129.456 138.857 C 126.680 136.067,125.958 135.110,126.065 134.357 C 126.324 132.524,127.779 132.921,130.548 135.581 C 132.851 137.792,133.138 137.956,133.640 137.351 C 134.131 136.760,134.102 136.714,133.383 136.942 C 132.756 137.141,132.090 136.702,130.435 134.999 C 127.574 132.056,125.600 131.979,125.600 134.812 C 125.600 135.851,132.707 142.800,133.770 142.800 C 134.729 142.800,134.809 142.688,137.586 137.427 C 138.719 135.279,140.173 132.685,140.816 131.661 L 141.985 129.800 141.992 136.680 C 141.999 142.815,141.924 143.604,141.300 143.968 C 140.915 144.192,140.803 144.381,141.051 144.388 C 142.240 144.420,142.417 143.227,142.309 135.948 C 142.206 129.030,142.162 128.659,141.557 129.600 M135.828 132.661 C 135.256 133.684,134.852 134.585,134.929 134.663 C 135.007 134.740,135.561 133.903,136.160 132.802 C 136.760 131.701,137.164 130.800,137.059 130.800 C 136.954 130.800,136.400 131.637,135.828 132.661 M124.520 134.800 C 124.520 136.010,124.595 136.505,124.687 135.900 C 124.778 135.295,124.778 134.305,124.687 133.700 C 124.595 133.095,124.520 133.590,124.520 134.800 M239.596 143.896 C 235.308 148.239,233.034 150.624,234.543 149.196 C 236.571 147.276,245.673 138.177,247.567 136.176 C 247.658 136.079,247.657 136.000,247.563 136.000 C 247.469 136.000,243.884 139.553,239.596 143.896 M124.501 139.800 C 124.505 140.680,124.587 140.993,124.683 140.495 C 124.779 139.998,124.775 139.278,124.675 138.895 C 124.575 138.513,124.496 138.920,124.501 139.800 M222.200 141.600 C 221.799 142.043,221.562 142.495,221.672 142.605 C 221.782 142.715,222.199 142.443,222.600 142.000 C 223.001 141.557,223.238 141.105,223.128 140.995 C 223.018 140.885,222.601 141.157,222.200 141.600 M124.454 142.700 C 124.425 143.415,124.475 144.000,124.567 144.000 C 124.659 144.000,125.064 144.114,125.467 144.254 C 126.144 144.488,126.149 144.466,125.528 143.954 C 125.159 143.649,124.778 142.950,124.683 142.400 C 124.538 141.569,124.500 141.620,124.454 142.700 M217.242 146.642 C 215.182 148.725,213.572 150.505,213.664 150.597 C 213.756 150.690,215.518 149.061,217.579 146.979 C 219.640 144.897,221.250 143.117,221.157 143.024 C 221.064 142.931,219.302 144.559,217.242 146.642 M129.680 144.298 C 131.594 144.371,134.834 144.371,136.880 144.298 C 138.926 144.226,137.360 144.166,133.400 144.165 C 129.440 144.165,127.766 144.224,129.680 144.298 M147.600 145.169 C 147.600 145.372,147.134 146.092,146.564 146.769 C 145.493 148.043,145.800 148.542,146.891 147.300 C 147.548 146.551,148.204 144.800,147.827 144.800 C 147.702 144.800,147.600 144.966,147.600 145.169 M121.212 145.446 C 121.194 146.097,122.778 148.002,123.329 147.991 C 123.588 147.986,123.418 147.671,122.952 147.291 C 122.486 146.911,121.906 146.240,121.664 145.800 C 121.422 145.360,121.219 145.201,121.212 145.446 M124.262 148.500 C 124.501 148.888,144.052 148.882,144.662 148.494 C 144.916 148.332,140.388 148.200,134.600 148.200 C 128.812 148.200,124.160 148.335,124.262 148.500 M208.638 155.238 C 206.921 157.004,205.585 158.518,205.669 158.602 C 205.753 158.687,207.246 157.330,208.988 155.588 C 210.729 153.845,212.064 152.331,211.956 152.223 C 211.847 152.114,210.354 153.471,208.638 155.238 M227.592 155.875 C 225.506 158.007,224.145 159.492,224.566 159.175 C 224.987 158.859,225.797 158.124,226.366 157.542 C 230.914 152.888,231.749 152.000,231.578 152.000 C 231.472 152.000,229.678 153.744,227.592 155.875 M122.417 158.338 L 120.800 159.876 120.800 169.924 C 120.800 184.791,120.013 184.000,134.804 184.000 L 145.143 184.000 146.572 182.653 C 147.602 181.681,147.990 180.984,147.964 180.153 L 147.928 179.000 147.561 180.267 C 147.359 180.964,146.642 181.999,145.966 182.567 L 144.739 183.600 134.749 183.600 C 120.406 183.600,121.194 184.396,121.213 169.913 C 121.230 156.518,120.498 157.200,134.852 157.200 C 140.768 157.200,144.788 157.362,145.326 157.622 C 146.170 158.030,146.174 158.023,145.424 157.422 C 144.766 156.895,143.065 156.800,134.340 156.800 L 124.034 156.800 122.417 158.338 M146.415 158.200 C 146.417 158.420,146.786 159.050,147.236 159.600 C 147.779 160.264,147.915 160.331,147.640 159.800 C 146.966 158.495,146.412 157.772,146.415 158.200 M124.837 160.556 C 124.526 160.931,124.416 162.787,124.501 166.256 L 124.626 171.400 124.713 166.143 C 124.818 159.822,124.039 160.371,132.805 160.431 L 139.505 160.477 137.912 163.539 C 137.036 165.222,135.957 167.194,135.514 167.921 C 135.071 168.648,134.798 169.332,134.908 169.441 C 135.017 169.551,136.046 167.876,137.194 165.720 C 138.341 163.564,139.532 161.515,139.841 161.168 C 140.149 160.820,140.281 160.415,140.134 160.268 C 139.566 159.699,125.325 159.967,124.837 160.556 M201.029 162.829 C 199.524 164.368,198.366 165.699,198.453 165.787 C 198.541 165.875,199.861 164.704,201.386 163.186 C 202.911 161.667,204.070 160.336,203.961 160.228 C 203.852 160.119,202.533 161.289,201.029 162.829 M219.392 164.100 L 215.800 167.800 219.500 164.208 C 222.936 160.872,223.382 160.400,223.092 160.400 C 223.032 160.400,221.367 162.065,219.392 164.100 M141.705 163.700 C 141.488 163.975,139.825 167.026,138.009 170.480 C 136.193 173.934,134.412 176.838,134.053 176.933 C 133.461 177.091,133.463 177.112,134.067 177.154 C 134.796 177.204,135.396 176.321,138.106 171.200 C 142.127 163.605,142.000 163.604,142.000 171.226 C 142.000 179.491,142.803 178.800,133.194 178.800 C 124.084 178.800,124.937 179.201,124.678 174.800 L 124.548 172.600 124.474 175.126 C 124.350 179.377,123.972 179.200,133.186 179.200 C 139.886 179.200,141.242 179.101,141.771 178.571 C 142.345 177.998,142.805 163.200,142.249 163.200 C 142.166 163.200,141.921 163.425,141.705 163.700 M196.667 167.067 C 195.945 167.789,196.718 168.925,200.300 172.408 L 204.200 176.200 200.457 172.350 C 197.401 169.205,196.764 168.343,196.984 167.650 C 197.258 166.786,197.148 166.585,196.667 167.067 M125.867 168.267 C 125.286 168.847,125.652 170.309,126.600 171.200 C 127.150 171.717,127.600 171.934,127.600 171.684 C 127.600 171.433,127.222 171.026,126.760 170.778 C 126.124 170.438,125.961 170.045,126.091 169.164 C 126.275 167.905,126.266 167.867,125.867 168.267 M130.017 169.881 C 133.137 173.172,133.199 173.190,134.222 171.075 C 134.779 169.923,134.779 169.875,134.219 170.576 C 133.879 171.004,133.600 171.499,133.600 171.676 C 133.600 172.522,132.380 171.814,130.715 170.000 C 129.705 168.900,128.733 168.000,128.556 168.000 C 128.379 168.000,129.036 168.846,130.017 169.881 M210.699 172.697 C 206.212 177.184,205.962 177.369,205.101 176.833 C 204.276 176.319,204.246 176.328,204.749 176.936 C 205.657 178.034,206.043 177.783,210.812 172.986 C 216.098 167.670,215.783 168.000,215.565 168.000 C 215.472 168.000,213.282 170.114,210.699 172.697 M128.000 172.342 C 128.000 172.526,128.360 173.002,128.800 173.400 C 129.240 173.798,129.600 173.956,129.600 173.751 C 129.600 173.546,129.240 173.070,128.800 172.693 C 128.360 172.316,128.000 172.158,128.000 172.342 M130.013 174.233 C 130.030 174.720,130.813 175.663,131.800 176.385 C 132.240 176.706,132.060 176.347,131.400 175.587 C 130.740 174.826,130.155 174.128,130.100 174.035 C 130.045 173.943,130.006 174.032,130.013 174.233 M189.659 179.700 C 189.170 180.635,189.002 181.064,189.285 180.653 C 189.568 180.241,190.103 179.521,190.474 179.053 L 191.147 178.200 193.274 180.200 L 195.400 182.200 193.415 180.100 C 191.016 177.562,190.789 177.538,189.659 179.700 M186.465 185.017 C 185.509 187.116,186.490 187.980,188.224 186.567 C 189.023 185.916,188.755 185.932,187.000 186.643 C 186.295 186.928,186.223 186.278,186.832 185.139 C 187.070 184.695,187.189 184.256,187.097 184.164 C 187.005 184.072,186.721 184.456,186.465 185.017 M124.938 191.506 C 124.683 191.668,128.941 191.800,134.399 191.800 C 139.857 191.800,144.240 191.665,144.138 191.500 C 143.899 191.112,125.548 191.118,124.938 191.506 M122.100 193.041 C 121.605 193.606,121.205 194.368,121.212 194.734 C 121.222 195.279,121.305 195.254,121.667 194.600 C 121.910 194.160,122.476 193.395,122.924 192.900 C 123.373 192.405,123.573 192.003,123.370 192.007 C 123.166 192.011,122.595 192.476,122.100 193.041 M146.564 193.231 C 147.134 193.908,147.600 194.658,147.600 194.897 C 147.600 195.137,147.716 195.217,147.858 195.076 C 148.158 194.775,146.362 192.007,145.864 192.003 C 145.680 192.001,145.995 192.554,146.564 193.231 M124.880 195.280 C 124.581 195.579,124.428 196.826,124.474 198.580 C 124.542 201.168,124.559 201.219,124.678 199.200 C 124.936 194.825,124.229 195.200,132.208 195.200 C 136.053 195.200,139.199 195.335,139.199 195.500 C 139.198 195.665,138.821 196.416,138.362 197.169 C 137.370 198.797,136.673 200.526,137.121 200.249 C 137.296 200.141,137.866 199.141,138.388 198.026 C 138.910 196.912,139.486 196.000,139.668 196.000 C 139.851 196.000,140.000 195.730,140.000 195.400 C 140.000 194.608,125.665 194.495,124.880 195.280 M120.972 205.200 C 120.972 210.370,121.029 212.485,121.099 209.900 C 121.168 207.315,121.168 203.085,121.099 200.500 C 121.029 197.915,120.972 200.030,120.972 205.200 M140.035 201.431 C 138.074 205.067,137.877 205.955,139.759 202.673 C 141.995 198.776,142.000 198.783,142.000 205.712 C 142.000 212.865,142.352 212.266,138.000 212.522 C 135.981 212.641,136.032 212.658,138.620 212.726 C 142.501 212.828,142.400 213.030,142.400 205.120 C 142.400 197.448,142.282 197.264,140.035 201.431 M135.428 202.661 C 134.856 203.684,134.452 204.585,134.529 204.663 C 134.607 204.740,135.161 203.903,135.760 202.802 C 136.360 201.701,136.764 200.800,136.659 200.800 C 136.554 200.800,136.000 201.637,135.428 202.661 M218.600 201.091 C 217.940 201.185,217.251 201.406,217.069 201.582 C 216.887 201.758,217.697 201.723,218.869 201.505 C 220.042 201.287,224.597 201.183,229.000 201.274 C 233.400 201.365,236.010 201.314,234.800 201.160 C 232.439 200.859,220.585 200.808,218.600 201.091 M124.487 206.820 C 124.383 212.841,124.373 212.826,128.180 212.726 C 130.768 212.658,130.819 212.641,128.800 212.522 C 124.539 212.271,124.841 212.685,124.699 206.895 L 124.574 201.800 124.487 206.820 M126.262 202.731 C 125.314 203.779,125.494 206.000,126.528 206.000 C 126.771 206.000,127.392 206.495,127.907 207.100 L 128.844 208.200 128.166 207.084 C 127.792 206.470,127.152 205.788,126.743 205.570 C 125.229 204.759,126.227 202.052,127.815 202.661 C 128.307 202.850,128.441 202.789,128.242 202.468 C 127.821 201.787,127.020 201.894,126.262 202.731 M212.000 203.034 C 210.690 203.570,210.677 203.592,211.800 203.375 C 212.460 203.248,213.171 202.976,213.380 202.772 C 213.859 202.303,213.721 202.329,212.000 203.034 M242.200 203.200 C 243.892 203.631,245.344 203.631,244.000 203.200 C 243.450 203.024,242.550 202.883,242.000 202.887 C 241.102 202.894,241.122 202.926,242.200 203.200 M247.774 204.758 C 247.897 204.958,248.580 205.324,249.290 205.571 C 250.788 206.094,250.335 205.579,248.675 204.873 C 248.056 204.609,247.650 204.558,247.774 204.758 M133.662 206.049 C 133.231 206.740,133.059 206.782,132.513 206.330 C 131.970 205.882,131.901 205.893,132.068 206.400 C 132.379 207.341,133.499 207.335,134.005 206.390 C 134.603 205.273,134.322 204.993,133.662 206.049 M137.000 207.200 C 136.659 207.860,136.469 208.400,136.579 208.400 C 136.689 208.400,137.059 207.860,137.400 207.200 C 137.741 206.540,137.931 206.000,137.821 206.000 C 137.711 206.000,137.341 206.540,137.000 207.200 M251.767 213.800 C 251.767 217.980,251.826 219.636,251.898 217.479 C 251.971 215.323,251.970 211.903,251.898 209.879 C 251.825 207.856,251.766 209.620,251.767 213.800 M130.800 210.112 C 131.790 211.161,132.555 212.194,132.500 212.409 C 132.445 212.624,132.902 212.800,133.515 212.800 C 134.312 212.800,134.646 212.590,134.685 212.061 C 134.728 211.489,134.526 211.363,133.791 211.504 C 133.152 211.626,132.540 211.377,131.920 210.743 C 131.413 210.224,130.549 209.441,129.999 209.003 C 129.450 208.564,129.810 209.063,130.800 210.112 M221.800 212.077 C 220.480 212.286,219.265 212.588,219.100 212.748 C 218.936 212.908,219.956 212.850,221.368 212.619 C 222.779 212.388,224.069 212.064,224.234 211.899 C 224.399 211.735,224.458 211.622,224.367 211.648 C 224.275 211.675,223.120 211.868,221.800 212.077 M230.000 212.266 C 230.550 212.360,231.869 212.586,232.931 212.769 C 233.993 212.952,234.713 212.954,234.531 212.772 C 234.349 212.590,233.030 212.364,231.600 212.268 C 230.170 212.173,229.450 212.172,230.000 212.266 M147.398 215.662 C 146.299 218.079,145.678 218.200,134.343 218.200 C 128.625 218.200,124.363 218.317,124.873 218.460 C 126.517 218.922,143.204 218.832,144.754 218.353 C 146.210 217.904,148.181 215.942,147.930 215.191 C 147.856 214.968,147.617 215.180,147.398 215.662 M121.202 215.494 C 121.205 215.982,123.107 218.221,123.331 218.000 C 123.443 217.890,123.009 217.212,122.367 216.493 C 121.725 215.775,121.201 215.325,121.202 215.494 M244.400 217.325 C 244.400 217.424,245.061 218.009,245.868 218.625 C 246.676 219.241,247.211 219.541,247.056 219.291 C 246.740 218.779,244.400 217.047,244.400 217.325 M210.623 219.289 C 210.280 219.778,210.015 220.543,210.034 220.989 C 210.060 221.595,210.154 221.516,210.407 220.674 C 210.592 220.055,210.959 219.290,211.221 218.974 C 211.483 218.658,211.596 218.400,211.472 218.400 C 211.347 218.400,210.965 218.800,210.623 219.289 M122.628 227.347 C 121.843 228.088,121.201 228.943,121.201 229.247 C 121.202 229.551,121.533 229.260,121.936 228.600 C 122.792 227.200,124.045 226.483,126.000 226.276 C 127.331 226.135,127.318 226.125,125.728 226.064 C 124.334 226.011,123.821 226.223,122.628 227.347 M144.787 226.633 C 145.550 226.964,146.312 227.452,146.481 227.717 C 146.694 228.052,146.790 228.061,146.794 227.746 C 146.802 227.147,145.019 225.996,144.114 226.016 C 143.706 226.025,143.995 226.289,144.787 226.633 M147.234 228.400 C 147.246 228.730,147.411 229.360,147.600 229.800 L 147.944 230.600 147.966 229.800 C 147.978 229.360,147.813 228.730,147.600 228.400 C 147.255 227.867,147.215 227.867,147.234 228.400 M210.210 229.195 C 210.324 229.962,210.719 230.862,211.087 231.195 C 211.669 231.722,211.699 231.722,211.314 231.200 C 211.071 230.870,210.676 229.970,210.437 229.200 L 210.003 227.800 210.210 229.195 M125.100 229.632 C 123.957 230.298,124.040 246.579,125.190 247.195 C 125.689 247.462,128.748 247.574,133.490 247.499 L 141.000 247.381 133.380 247.291 C 128.095 247.228,125.613 247.053,125.280 246.720 C 124.358 245.798,124.626 230.521,125.574 230.014 C 126.562 229.485,139.592 229.465,140.974 229.990 L 142.000 230.380 142.000 238.016 C 142.000 242.515,141.830 245.970,141.586 246.426 C 141.348 246.871,141.330 247.200,141.543 247.200 C 142.659 247.200,142.873 230.930,141.771 229.829 C 141.023 229.080,126.345 228.907,125.100 229.632 M120.973 239.600 C 120.973 244.990,121.030 247.195,121.099 244.500 C 121.168 241.805,121.168 237.395,121.099 234.700 C 121.030 232.005,120.973 234.210,120.973 239.600 M225.141 238.901 C 225.343 239.103,225.933 239.201,226.454 239.119 C 227.255 238.993,227.198 238.937,226.087 238.752 C 225.293 238.621,224.919 238.679,225.141 238.901 M202.600 242.800 C 203.906 244.120,205.065 245.200,205.175 245.200 C 205.285 245.200,204.306 244.120,203.000 242.800 C 201.694 241.480,200.535 240.400,200.425 240.400 C 200.315 240.400,201.294 241.480,202.600 242.800 M232.200 240.800 C 232.860 240.968,233.850 241.105,234.400 241.105 C 235.292 241.105,235.270 241.072,234.200 240.800 C 233.540 240.632,232.550 240.495,232.000 240.495 C 231.108 240.495,231.130 240.528,232.200 240.800 M238.627 242.355 C 239.052 242.744,241.529 243.396,241.154 243.020 C 241.019 242.886,240.311 242.604,239.581 242.395 C 238.851 242.185,238.422 242.168,238.627 242.355 M209.776 247.770 C 210.204 248.117,210.924 248.385,211.376 248.366 C 212.037 248.338,211.989 248.267,211.131 248.009 C 210.544 247.831,209.824 247.563,209.531 247.413 C 209.239 247.263,209.349 247.424,209.776 247.770 M249.564 249.133 C 249.780 249.536,250.271 250.121,250.655 250.433 C 251.087 250.784,250.990 250.504,250.401 249.700 C 249.351 248.265,248.957 247.998,249.564 249.133 M147.388 250.106 C 146.778 252.534,145.502 252.800,134.461 252.800 C 123.470 252.800,123.036 252.719,121.799 250.443 C 121.487 249.869,121.225 249.619,121.216 249.886 C 121.207 250.153,121.759 251.008,122.441 251.786 L 123.683 253.200 134.413 253.200 L 145.143 253.200 146.572 251.853 C 147.357 251.112,148.000 250.212,148.000 249.853 C 148.000 248.908,147.652 249.052,147.388 250.106 M215.071 249.609 C 215.469 249.980,219.354 250.821,218.990 250.457 C 218.849 250.316,217.836 249.998,216.738 249.751 C 215.640 249.504,214.890 249.440,215.071 249.609 M223.060 251.598 C 223.247 251.773,224.273 252.097,225.340 252.318 C 226.407 252.539,227.127 252.577,226.940 252.402 C 226.753 252.227,225.727 251.903,224.660 251.682 C 223.593 251.461,222.873 251.423,223.060 251.598 M230.833 253.744 C 230.925 253.823,231.540 254.008,232.200 254.156 C 233.076 254.352,233.238 254.315,232.800 254.018 C 232.260 253.653,230.432 253.398,230.833 253.744 M253.831 257.000 C 253.958 257.880,254.222 258.765,254.417 258.966 C 254.612 259.167,254.588 258.627,254.362 257.766 C 253.761 255.465,253.568 255.188,253.831 257.000 M240.213 260.331 C 240.363 260.624,240.631 261.344,240.809 261.931 C 241.067 262.789,241.138 262.837,241.166 262.176 C 241.185 261.724,240.917 261.004,240.570 260.576 C 240.224 260.149,240.063 260.039,240.213 260.331 M195.378 269.313 C 195.270 269.595,195.235 273.150,195.300 277.213 L 195.419 284.600 195.510 276.900 L 195.600 269.200 196.636 269.200 C 197.289 269.200,198.469 269.881,199.823 271.038 C 201.006 272.048,202.205 272.783,202.487 272.669 C 202.877 272.513,202.866 272.456,202.443 272.432 C 202.137 272.414,200.938 271.590,199.779 270.600 C 197.665 268.794,195.788 268.245,195.378 269.313 M241.048 269.300 C 240.978 269.575,240.717 270.418,240.468 271.173 C 240.167 272.084,240.157 272.403,240.438 272.122 C 240.869 271.691,241.658 268.800,241.345 268.800 C 241.252 268.800,241.118 269.025,241.048 269.300 M253.840 270.840 C 253.693 271.757,253.652 272.585,253.747 272.680 C 253.842 272.776,254.046 272.110,254.200 271.200 C 254.354 270.290,254.396 269.462,254.293 269.360 C 254.190 269.257,253.987 269.923,253.840 270.840 M204.400 274.179 C 204.400 274.289,204.940 274.659,205.600 275.000 C 206.260 275.341,206.800 275.531,206.800 275.421 C 206.800 275.311,206.260 274.941,205.600 274.600 C 204.940 274.259,204.400 274.069,204.400 274.179 M251.700 276.500 C 251.270 277.675,251.280 277.726,251.812 277.024 C 252.321 276.352,252.621 275.200,252.288 275.200 C 252.226 275.200,251.961 275.785,251.700 276.500 M213.541 278.501 C 213.743 278.703,214.333 278.801,214.854 278.719 C 215.655 278.593,215.598 278.537,214.487 278.352 C 213.693 278.221,213.319 278.279,213.541 278.501 M222.900 280.287 C 223.505 280.378,224.495 280.378,225.100 280.287 C 225.705 280.195,225.210 280.120,224.000 280.120 C 222.790 280.120,222.295 280.195,222.900 280.287 M197.200 284.979 C 197.200 285.089,197.740 285.459,198.400 285.800 C 199.060 286.141,199.600 286.331,199.600 286.221 C 199.600 286.111,199.060 285.741,198.400 285.400 C 197.740 285.059,197.200 284.869,197.200 284.979 M241.000 287.227 C 240.340 287.650,240.005 287.997,240.256 287.998 C 240.506 287.999,241.136 287.646,241.656 287.213 C 242.845 286.223,242.559 286.229,241.000 287.227 M202.400 287.427 C 204.183 288.127,205.355 288.395,204.978 288.018 C 204.757 287.797,203.951 287.520,203.188 287.404 C 202.424 287.287,202.070 287.298,202.400 287.427 M208.200 289.386 C 209.038 289.755,212.846 290.287,212.531 289.992 C 212.349 289.821,211.210 289.575,210.000 289.446 C 208.790 289.316,207.980 289.289,208.200 289.386 M234.800 289.600 C 234.008 289.854,233.967 289.920,234.600 289.920 C 235.040 289.920,235.850 289.776,236.400 289.600 C 237.192 289.346,237.233 289.280,236.600 289.280 C 236.160 289.280,235.350 289.424,234.800 289.600 M103.301 292.600 C 103.305 293.480,103.387 293.793,103.483 293.295 C 103.579 292.798,103.575 292.078,103.475 291.695 C 103.375 291.313,103.296 291.720,103.301 292.600 M90.501 295.000 C 90.505 295.880,90.587 296.193,90.683 295.695 C 90.779 295.198,90.775 294.478,90.675 294.095 C 90.575 293.713,90.496 294.120,90.501 295.000 M103.606 295.233 C 103.609 295.765,103.789 296.470,104.006 296.800 C 104.282 297.222,104.323 296.985,104.142 296.000 C 103.825 294.275,103.598 293.949,103.606 295.233 M278.084 299.500 C 277.681 300.847,277.694 300.921,278.217 300.224 C 278.726 299.546,279.039 298.000,278.667 298.000 C 278.594 298.000,278.332 298.675,278.084 299.500 M292.002 300.860 C 291.755 301.817,291.451 302.960,291.327 303.400 C 291.202 303.840,291.224 304.084,291.376 303.941 C 291.729 303.609,292.821 299.488,292.612 299.278 C 292.524 299.191,292.250 299.902,292.002 300.860 M277.200 301.478 C 277.200 301.703,276.728 302.584,276.152 303.433 C 275.575 304.283,275.407 304.726,275.778 304.418 C 276.619 303.720,277.738 301.605,277.429 301.296 C 277.303 301.170,277.200 301.252,277.200 301.478 M107.600 303.600 C 108.070 304.260,108.544 304.800,108.654 304.800 C 108.764 304.800,108.470 304.260,108.000 303.600 C 107.530 302.940,107.056 302.400,106.946 302.400 C 106.836 302.400,107.130 302.940,107.600 303.600 M93.878 306.595 C 94.244 307.362,94.614 307.919,94.701 307.832 C 94.884 307.649,93.670 305.200,93.396 305.200 C 93.295 305.200,93.512 305.828,93.878 306.595 M289.400 307.600 C 288.843 308.700,288.477 309.600,288.587 309.600 C 288.697 309.600,289.243 308.700,289.800 307.600 C 290.357 306.500,290.723 305.600,290.613 305.600 C 290.503 305.600,289.957 306.500,289.400 307.600 M111.967 307.745 C 112.500 308.401,114.000 309.393,114.000 309.089 C 114.000 309.013,113.415 308.522,112.700 307.999 C 111.896 307.410,111.616 307.313,111.967 307.745 M271.970 308.288 C 271.258 309.086,271.213 309.219,271.798 308.788 C 273.072 307.850,273.686 307.200,273.298 307.200 C 273.101 307.200,272.503 307.690,271.970 308.288 M95.416 309.200 C 96.265 310.729,97.562 312.361,99.400 314.212 C 100.500 315.319,100.845 315.590,100.166 314.813 C 99.488 314.036,98.237 312.500,97.386 311.400 C 95.557 309.034,94.943 308.348,95.416 309.200 M114.400 309.390 C 114.400 309.677,116.688 310.800,117.274 310.800 C 117.557 310.800,117.116 310.440,116.296 310.000 C 114.760 309.177,114.400 309.061,114.400 309.390 M120.315 311.672 C 121.191 312.020,264.289 312.008,265.524 311.660 C 266.031 311.517,233.413 311.400,193.038 311.400 C 152.664 311.400,119.938 311.522,120.315 311.672 M285.579 313.422 C 285.051 313.984,284.888 314.341,285.218 314.214 C 285.739 314.015,287.034 312.400,286.673 312.400 C 286.600 312.400,286.107 312.860,285.579 313.422 M283.620 315.779 C 283.114 316.317,281.649 317.524,280.364 318.459 C 279.079 319.395,278.103 320.236,278.196 320.329 C 278.395 320.528,283.060 316.864,284.162 315.644 C 285.228 314.463,284.742 314.584,283.620 315.779 M102.000 316.527 C 102.000 316.984,104.552 319.175,105.100 319.188 C 105.375 319.195,105.600 319.361,105.600 319.557 C 105.600 319.754,105.870 320.018,106.200 320.145 C 107.256 320.550,106.841 319.756,105.700 319.187 C 105.095 318.886,104.015 318.100,103.300 317.441 C 102.585 316.782,102.000 316.371,102.000 316.527 M107.764 320.742 C 108.044 321.195,110.809 322.524,111.024 322.310 C 111.111 322.222,110.363 321.753,109.362 321.266 C 108.361 320.780,107.642 320.544,107.764 320.742 M275.000 321.786 C 274.340 322.088,274.081 322.350,274.424 322.368 C 274.766 322.385,275.396 322.136,275.824 321.813 C 276.788 321.083,276.551 321.076,275.000 321.786 M272.000 323.034 C 270.690 323.570,270.677 323.592,271.800 323.375 C 272.460 323.248,273.171 322.976,273.380 322.772 C 273.859 322.303,273.721 322.329,272.000 323.034 M114.400 323.567 C 115.610 323.996,117.140 324.344,117.800 324.340 C 118.596 324.335,118.192 324.138,116.600 323.755 C 112.601 322.793,112.096 322.750,114.400 323.567 M157.068 324.700 C 176.466 324.757,208.326 324.757,227.868 324.700 C 247.411 324.643,231.540 324.596,192.600 324.596 C 153.660 324.596,137.671 324.643,157.068 324.700 ",
                    fill: '#dba561',
                    stroke: 'none',
                    'fill-rule': 'evenodd'
                }
            ),
            el(
                'path',
                { 
                    d: "M187.300 0.287 C 187.905 0.378,188.895 0.378,189.500 0.287 C 190.105 0.195,189.610 0.120,188.400 0.120 C 187.190 0.120,186.695 0.195,187.300 0.287 M209.491 0.289 C 210.201 0.377,211.461 0.379,212.291 0.292 C 213.121 0.205,212.540 0.133,211.000 0.131 C 209.460 0.129,208.781 0.200,209.491 0.289 M221.305 1.087 C 221.914 1.179,222.814 1.177,223.305 1.082 C 223.797 0.987,223.300 0.911,222.200 0.914 C 221.100 0.917,220.697 0.995,221.305 1.087 M227.200 1.959 C 227.200 2.229,228.081 2.400,229.467 2.400 C 232.201 2.400,232.116 2.116,229.279 1.771 C 227.877 1.600,227.200 1.661,227.200 1.959 M262.400 10.035 C 262.400 10.236,262.790 10.400,263.267 10.400 C 263.743 10.400,264.008 10.275,263.855 10.122 C 263.423 9.689,262.400 9.629,262.400 10.035 M280.800 17.200 C 281.576 17.701,282.000 17.701,282.000 17.200 C 282.000 16.980,281.595 16.803,281.100 16.806 C 280.372 16.811,280.315 16.886,280.800 17.200 M288.800 20.757 C 288.800 21.201,290.031 21.703,290.346 21.388 C 290.473 21.261,290.312 20.989,289.988 20.784 C 289.240 20.311,288.800 20.301,288.800 20.757 M296.800 25.200 C 296.800 25.420,297.070 25.600,297.400 25.600 C 297.730 25.600,298.000 25.420,298.000 25.200 C 298.000 24.980,297.730 24.800,297.400 24.800 C 297.070 24.800,296.800 24.980,296.800 25.200 M308.400 31.986 C 308.400 32.214,308.651 32.400,308.957 32.400 C 309.264 32.400,309.618 32.670,309.745 33.000 C 309.871 33.330,310.263 33.600,310.616 33.600 C 311.152 33.600,311.169 33.512,310.720 33.063 C 309.847 32.190,308.400 31.518,308.400 31.986 M317.700 38.276 C 318.085 38.376,318.400 38.715,318.400 39.029 C 318.400 39.357,318.783 39.596,319.300 39.591 L 320.200 39.582 319.200 38.800 C 318.650 38.370,317.930 38.035,317.600 38.055 C 317.177 38.082,317.206 38.147,317.700 38.276 M333.538 51.200 C 334.198 51.860,334.931 52.400,335.166 52.400 C 335.401 52.400,335.028 51.860,334.337 51.200 C 333.646 50.540,332.914 50.000,332.710 50.000 C 332.506 50.000,332.878 50.540,333.538 51.200 M309.000 56.000 C 308.853 56.239,309.337 56.400,310.200 56.400 C 311.063 56.400,311.547 56.239,311.400 56.000 C 311.264 55.780,310.724 55.600,310.200 55.600 C 309.676 55.600,309.136 55.780,309.000 56.000 M313.606 57.140 C 316.827 58.852,318.351 63.505,316.708 66.616 C 316.016 67.927,308.471 75.600,307.874 75.600 C 307.675 75.600,306.452 74.500,305.156 73.154 C 303.860 71.809,302.800 70.849,302.800 71.021 C 302.800 71.192,303.069 71.618,303.398 71.966 C 307.986 76.830,307.651 76.740,310.591 73.900 C 311.786 72.745,313.413 71.200,314.206 70.467 C 316.412 68.428,318.000 65.590,318.000 63.689 C 318.000 60.466,315.227 56.400,313.029 56.400 C 312.415 56.400,312.558 56.583,313.606 57.140 M305.600 57.216 C 305.600 57.444,304.880 58.358,304.000 59.247 C 303.120 60.136,302.400 61.002,302.400 61.171 C 302.400 61.340,303.390 60.488,304.600 59.278 C 307.026 56.852,307.060 56.800,306.200 56.800 C 305.870 56.800,305.600 56.987,305.600 57.216 M341.762 59.262 C 341.585 59.548,341.652 59.615,341.938 59.438 C 342.212 59.269,342.400 59.407,342.400 59.776 C 342.400 60.119,342.698 60.400,343.062 60.400 C 343.657 60.400,343.651 60.319,343.000 59.600 C 342.153 58.664,342.134 58.659,341.762 59.262 M300.869 62.439 C 300.128 63.624,300.457 63.713,301.319 62.561 C 301.714 62.032,301.892 61.600,301.715 61.600 C 301.538 61.600,301.157 61.978,300.869 62.439 M298.661 64.805 C 297.949 66.010,298.083 67.843,298.848 67.370 C 299.092 67.220,299.057 66.910,298.757 66.548 C 298.371 66.083,298.449 65.730,299.149 64.783 C 299.630 64.132,299.877 63.600,299.698 63.600 C 299.519 63.600,299.052 64.142,298.661 64.805 M350.400 68.229 C 350.400 68.533,351.478 69.600,351.786 69.600 C 351.919 69.600,351.835 69.240,351.600 68.800 C 351.209 68.069,350.400 67.684,350.400 68.229 M300.800 69.142 C 300.800 69.326,301.160 69.802,301.600 70.200 C 302.040 70.598,302.400 70.756,302.400 70.551 C 302.400 70.346,302.040 69.870,301.600 69.493 C 301.160 69.116,300.800 68.958,300.800 69.142 M290.880 72.480 C 290.616 72.744,290.405 73.149,290.412 73.380 C 290.419 73.611,290.608 73.485,290.832 73.100 C 291.617 71.752,292.737 72.421,297.058 76.819 C 302.199 82.050,302.032 81.716,300.366 83.435 C 299.121 84.720,299.004 85.386,300.215 84.300 C 300.521 84.025,301.048 83.568,301.386 83.284 C 302.677 82.200,302.051 81.127,297.449 76.538 C 293.009 72.111,291.921 71.439,290.880 72.480 M208.000 73.200 C 208.000 73.420,208.360 73.600,208.800 73.600 C 209.240 73.600,209.600 73.420,209.600 73.200 C 209.600 72.980,209.240 72.800,208.800 72.800 C 208.360 72.800,208.000 72.980,208.000 73.200 M168.500 74.324 C 167.248 74.921,166.770 75.600,167.600 75.600 C 167.820 75.600,168.000 75.420,168.000 75.200 C 168.000 74.980,168.315 74.794,168.700 74.786 C 169.085 74.778,169.850 74.514,170.400 74.200 C 171.836 73.379,170.266 73.482,168.500 74.324 M213.000 74.212 C 215.013 74.937,215.134 74.937,214.176 74.213 C 213.749 73.890,212.950 73.628,212.400 73.630 C 211.606 73.634,211.729 73.754,213.000 74.212 M288.882 74.324 C 288.377 74.713,288.089 75.155,288.241 75.308 C 288.394 75.461,288.852 75.201,289.259 74.732 C 290.414 73.400,290.276 73.251,288.882 74.324 M215.200 75.056 C 215.200 75.124,215.695 75.442,216.300 75.764 C 216.905 76.085,218.430 77.357,219.690 78.589 L 221.979 80.831 246.620 80.779 C 260.173 80.751,271.171 80.638,271.061 80.527 C 270.950 80.417,259.909 80.350,246.524 80.379 L 222.189 80.431 219.682 78.016 C 218.302 76.687,217.000 75.600,216.787 75.600 C 216.574 75.600,216.400 75.450,216.400 75.267 C 216.400 75.083,216.130 74.933,215.800 74.933 C 215.470 74.933,215.200 74.989,215.200 75.056 M164.871 76.600 C 164.439 77.150,163.925 77.600,163.729 77.600 C 163.533 77.600,163.055 78.137,162.667 78.794 C 162.280 79.450,161.836 79.962,161.681 79.930 C 161.526 79.899,161.130 79.992,160.800 80.137 C 160.470 80.282,150.570 80.449,138.800 80.509 L 117.400 80.617 139.533 80.608 L 161.666 80.600 162.750 79.400 C 163.347 78.740,164.508 77.615,165.331 76.900 C 166.166 76.175,166.569 75.600,166.243 75.600 C 165.921 75.600,165.304 76.050,164.871 76.600 M287.029 76.229 C 286.683 76.574,286.400 77.054,286.400 77.295 C 286.400 77.536,286.447 77.658,286.504 77.567 C 286.562 77.475,286.950 76.995,287.366 76.500 C 288.228 75.476,287.980 75.277,287.029 76.229 M285.062 78.331 C 284.698 78.734,284.400 79.211,284.400 79.393 C 284.400 79.574,284.760 79.307,285.200 78.800 C 285.640 78.293,286.000 77.815,286.000 77.739 C 286.000 77.439,285.695 77.632,285.062 78.331 M279.900 83.255 C 277.975 85.228,276.400 86.991,276.400 87.173 C 276.400 87.354,277.795 86.106,279.500 84.399 C 283.444 80.449,284.210 79.592,283.762 79.634 C 283.563 79.652,281.825 81.282,279.900 83.255 M271.600 80.400 C 271.600 80.620,271.881 80.800,272.224 80.800 C 272.567 80.800,272.736 80.980,272.600 81.200 C 272.464 81.420,272.543 81.600,272.776 81.600 C 273.009 81.600,273.200 81.240,273.200 80.800 C 273.200 80.267,272.933 80.000,272.400 80.000 C 271.960 80.000,271.600 80.180,271.600 80.400 M114.000 81.200 C 114.000 81.420,114.259 81.600,114.576 81.600 C 114.893 81.600,115.264 81.420,115.400 81.200 C 115.536 80.980,115.277 80.800,114.824 80.800 C 114.371 80.800,114.000 80.980,114.000 81.200 M110.100 82.312 C 109.165 82.671,108.400 83.104,108.400 83.274 C 108.400 83.444,108.895 83.384,109.500 83.142 C 110.105 82.899,110.960 82.556,111.400 82.379 C 111.840 82.203,112.470 81.970,112.800 81.861 C 113.199 81.729,113.132 81.662,112.600 81.661 C 112.160 81.660,111.035 81.953,110.100 82.312 M270.200 84.000 C 269.802 84.440,269.678 84.800,269.924 84.800 C 270.170 84.800,270.565 84.440,270.800 84.000 C 271.035 83.560,271.160 83.200,271.076 83.200 C 270.992 83.200,270.598 83.560,270.200 84.000 M106.000 84.200 C 105.366 84.963,105.961 84.956,106.976 84.187 C 107.598 83.717,107.628 83.600,107.125 83.600 C 106.780 83.600,106.274 83.870,106.000 84.200 M103.754 85.315 C 103.508 85.582,102.923 86.065,102.454 86.388 C 101.984 86.712,101.600 87.126,101.600 87.309 C 101.600 87.491,102.275 87.146,103.100 86.542 C 105.292 84.937,105.427 84.798,104.780 84.815 C 104.461 84.824,103.999 85.049,103.754 85.315 M267.841 86.100 C 267.204 86.714,266.799 87.332,266.941 87.475 C 267.084 87.617,267.200 87.523,267.200 87.267 C 267.200 87.010,267.427 86.800,267.704 86.800 C 268.155 86.800,269.441 85.222,269.128 85.053 C 269.057 85.015,268.479 85.486,267.841 86.100 M297.800 86.000 C 297.402 86.440,297.278 86.800,297.524 86.800 C 297.770 86.800,298.165 86.440,298.400 86.000 C 298.635 85.560,298.760 85.200,298.676 85.200 C 298.592 85.200,298.198 85.560,297.800 86.000 M294.100 89.722 C 292.725 91.105,291.600 92.378,291.600 92.552 C 291.600 92.870,295.335 89.215,296.355 87.900 C 297.379 86.579,296.597 87.211,294.100 89.722 M99.867 88.467 C 99.463 88.907,99.208 89.341,99.298 89.432 C 99.389 89.523,99.886 89.148,100.401 88.598 C 100.917 88.049,101.173 87.615,100.970 87.633 C 100.766 87.652,100.270 88.027,99.867 88.467 M263.600 90.200 C 262.183 91.630,261.191 92.800,261.396 92.800 C 261.733 92.800,266.400 88.084,266.400 87.744 C 266.400 87.419,266.064 87.714,263.600 90.200 M270.912 92.220 C 268.444 94.739,266.239 96.800,266.012 96.800 C 265.785 96.800,265.600 96.985,265.600 97.212 C 265.600 97.438,264.430 98.816,263.000 100.275 C 261.570 101.733,260.400 103.065,260.400 103.233 C 260.400 103.402,263.101 100.809,266.402 97.470 C 269.703 94.132,273.258 90.547,274.302 89.503 C 275.346 88.460,276.020 87.615,275.800 87.624 C 275.580 87.633,273.380 89.701,270.912 92.220 M366.012 88.200 C 366.008 88.420,366.363 89.140,366.800 89.800 C 367.237 90.460,367.592 90.730,367.588 90.400 C 367.582 89.737,366.022 87.560,366.012 88.200 M97.500 90.433 C 97.115 90.855,96.800 91.321,96.800 91.469 C 96.800 91.616,96.502 92.111,96.139 92.569 C 95.775 93.026,96.225 92.620,97.139 91.666 C 98.052 90.712,98.800 89.857,98.800 89.766 C 98.800 89.386,98.153 89.718,97.500 90.433 M260.400 93.041 C 260.400 93.246,259.905 93.722,259.300 94.097 C 258.591 94.536,258.427 94.782,258.838 94.789 C 259.588 94.802,261.049 93.315,260.664 92.931 C 260.519 92.786,260.400 92.835,260.400 93.041 M289.999 93.802 C 289.483 94.351,289.244 94.800,289.468 94.800 C 289.979 94.800,291.398 93.265,291.132 92.999 C 291.025 92.891,290.514 93.252,289.999 93.802 M94.960 93.906 C 94.277 94.363,91.245 100.834,90.981 102.400 C 90.828 103.308,91.089 102.886,91.724 101.200 C 92.593 98.893,93.252 97.582,95.114 94.462 C 95.667 93.535,95.644 93.449,94.960 93.906 M116.400 95.450 L 115.000 95.955 116.200 95.971 C 117.454 95.988,118.735 95.429,118.143 95.123 C 117.954 95.025,117.170 95.173,116.400 95.450 M222.311 96.026 C 221.940 96.672,221.780 97.200,221.954 97.200 C 222.283 97.200,223.324 95.191,223.107 94.974 C 223.040 94.907,222.682 95.380,222.311 96.026 M287.007 96.793 C 286.152 97.669,285.545 98.479,285.660 98.593 C 285.847 98.780,286.853 97.770,288.349 95.890 C 289.315 94.676,288.612 95.149,287.007 96.793 M112.000 97.069 C 112.000 97.290,111.505 97.704,110.900 97.988 C 110.295 98.272,110.019 98.584,110.286 98.681 C 110.870 98.893,112.657 97.324,112.271 96.938 C 112.122 96.789,112.000 96.848,112.000 97.069 M160.813 97.025 C 160.806 97.258,161.160 97.836,161.600 98.308 C 162.040 98.780,162.400 99.271,162.400 99.399 C 162.400 99.736,165.484 102.800,165.823 102.800 C 165.981 102.800,165.317 101.945,164.348 100.900 C 163.379 99.855,162.190 98.460,161.706 97.800 C 161.222 97.140,160.820 96.791,160.813 97.025 M220.730 98.685 C 219.648 100.514,217.237 102.694,215.257 103.634 C 214.100 104.184,213.619 104.593,213.980 104.718 C 214.299 104.829,214.629 104.713,214.713 104.460 C 214.798 104.207,215.190 104.000,215.584 104.000 C 215.979 104.000,216.526 103.730,216.800 103.400 C 217.074 103.070,217.454 102.800,217.644 102.800 C 218.220 102.800,219.600 101.458,219.600 100.899 C 219.600 100.611,219.870 100.271,220.200 100.145 C 220.530 100.018,220.800 99.679,220.800 99.391 C 220.800 99.102,221.007 98.798,221.260 98.713 C 221.513 98.629,221.646 98.337,221.555 98.065 C 221.460 97.779,221.112 98.040,220.730 98.685 M107.501 100.772 C 105.854 102.605,103.737 106.270,104.110 106.643 C 104.196 106.729,104.452 106.394,104.679 105.899 C 104.907 105.405,105.322 104.515,105.602 103.922 C 105.883 103.329,106.918 102.015,107.902 101.002 C 108.887 99.988,109.605 99.072,109.497 98.964 C 109.390 98.857,108.492 99.670,107.501 100.772 M279.280 104.561 C 276.156 107.716,273.600 110.436,273.600 110.607 C 273.600 110.778,276.238 108.279,279.461 105.054 C 282.685 101.828,285.241 99.108,285.141 99.008 C 285.041 98.908,282.403 101.407,279.280 104.561 M290.909 103.100 C 290.112 104.337,280.477 114.000,280.041 114.000 C 278.818 114.000,278.782 116.708,278.805 206.253 C 278.829 303.871,278.968 297.604,276.690 301.696 C 276.232 302.518,275.953 303.287,276.071 303.404 C 276.188 303.521,276.768 302.536,277.361 301.215 C 279.707 295.988,279.585 301.258,279.593 204.371 L 279.600 115.342 285.398 109.588 C 293.016 102.028,293.145 101.968,293.274 105.924 L 293.348 108.200 293.498 106.021 C 293.770 102.053,292.505 100.625,290.909 103.100 M166.400 103.168 C 166.400 103.545,169.079 104.911,169.493 104.745 C 169.691 104.665,169.076 104.222,168.127 103.759 C 167.177 103.297,166.400 103.031,166.400 103.168 M236.700 126.451 C 224.215 138.970,214.000 149.368,214.000 149.558 C 214.000 149.748,223.765 140.131,235.700 128.187 C 260.458 103.409,260.287 103.584,259.778 103.645 C 259.570 103.670,249.185 113.933,236.700 126.451 M90.493 105.200 C 90.493 105.970,90.575 106.285,90.676 105.900 C 90.776 105.515,90.776 104.885,90.676 104.500 C 90.575 104.115,90.493 104.430,90.493 105.200 M170.400 105.102 C 170.400 105.319,171.341 105.622,172.490 105.774 C 173.640 105.927,174.823 106.253,175.120 106.500 C 175.520 106.832,175.734 106.830,175.942 106.494 C 176.143 106.168,181.294 106.005,194.092 105.920 C 208.620 105.822,212.058 105.697,212.480 105.250 C 212.918 104.787,212.810 104.752,211.800 105.030 C 210.242 105.458,172.943 105.461,171.500 105.033 C 170.822 104.832,170.400 104.858,170.400 105.102 M103.600 109.100 C 103.600 109.925,103.596 151.891,103.591 202.358 C 103.586 252.824,103.676 294.209,103.791 294.324 C 103.906 294.439,104.000 252.473,104.000 201.067 C 104.000 149.660,103.910 107.600,103.800 107.600 C 103.690 107.600,103.600 108.275,103.600 109.100 M268.677 115.147 C 266.985 116.866,265.600 118.414,265.600 118.588 C 265.600 118.761,267.060 117.430,268.844 115.629 C 270.628 113.828,272.013 112.279,271.921 112.188 C 271.830 112.096,270.370 113.428,268.677 115.147 M293.724 117.800 C 293.726 119.120,293.801 119.612,293.890 118.893 C 293.979 118.174,293.977 117.094,293.886 116.493 C 293.795 115.892,293.722 116.480,293.724 117.800 M261.292 122.508 C 259.261 124.547,257.600 126.358,257.600 126.532 C 257.600 126.829,262.895 121.622,264.562 119.685 C 266.220 117.759,264.802 118.983,261.292 122.508 M124.400 121.179 C 124.400 121.463,127.742 121.600,134.638 121.600 C 145.633 121.600,146.566 121.757,147.542 123.768 C 147.769 124.236,147.958 124.358,147.973 124.047 C 147.988 123.743,147.385 122.915,146.634 122.206 L 145.268 120.918 134.834 120.838 C 127.750 120.784,124.400 120.894,124.400 121.179 M121.671 122.656 C 121.380 122.970,121.202 123.406,121.274 123.623 C 121.347 123.841,121.713 123.661,122.087 123.223 C 122.865 122.314,122.477 121.785,121.671 122.656 M120.649 125.015 C 120.512 125.373,120.428 126.686,120.463 127.933 L 120.526 130.200 120.786 127.400 C 121.064 124.398,121.041 123.995,120.649 125.015 M148.090 135.000 C 148.014 143.307,147.875 145.631,147.398 146.546 C 146.694 147.895,146.678 148.000,147.184 148.000 C 148.151 148.000,148.435 144.675,148.312 134.800 L 148.186 124.600 148.090 135.000 M125.400 127.200 C 125.536 127.420,125.457 127.600,125.224 127.600 C 124.982 127.600,124.827 128.330,124.864 129.300 C 124.925 130.923,124.936 130.936,125.095 129.600 C 125.187 128.830,125.546 127.885,125.893 127.500 C 126.470 126.860,126.465 126.800,125.838 126.800 C 125.461 126.800,125.264 126.980,125.400 127.200 M129.715 127.096 C 130.988 127.176,132.968 127.175,134.115 127.094 C 135.262 127.014,134.220 126.949,131.800 126.950 C 129.380 126.951,128.442 127.016,129.715 127.096 M137.480 127.058 C 138.053 127.291,137.731 128.279,135.935 131.800 C 135.261 133.120,134.891 134.020,135.112 133.800 C 135.462 133.451,138.800 127.220,138.800 126.915 C 138.800 126.852,138.395 126.814,137.900 126.832 C 137.405 126.849,137.216 126.951,137.480 127.058 M254.290 129.537 C 252.810 131.043,251.600 132.428,251.600 132.614 C 251.600 132.801,252.860 131.637,254.400 130.028 C 256.946 127.369,257.420 126.800,257.090 126.800 C 257.029 126.800,255.769 128.032,254.290 129.537 M139.435 133.981 C 138.426 135.731,137.600 137.269,137.600 137.399 C 137.600 137.529,136.932 138.797,136.115 140.218 C 134.267 143.431,133.688 143.486,130.833 140.719 C 129.652 139.575,128.889 139.019,129.138 139.483 C 129.631 140.405,132.000 142.893,132.000 142.489 C 132.000 142.352,132.216 142.456,132.480 142.720 C 133.427 143.667,134.699 143.258,135.655 141.700 C 136.161 140.875,136.886 139.861,137.267 139.446 C 137.648 139.031,138.082 138.131,138.230 137.446 C 138.379 136.761,138.613 136.110,138.750 136.000 C 138.888 135.890,139.430 134.945,139.956 133.900 C 141.416 130.997,141.631 131.523,141.511 137.700 L 141.400 143.400 133.300 143.508 L 125.200 143.617 125.147 141.108 C 125.105 139.079,125.045 138.867,124.836 140.000 C 124.694 140.770,124.680 141.940,124.805 142.600 L 125.033 143.800 133.416 143.800 L 141.800 143.800 141.910 137.300 C 142.037 129.779,141.937 129.644,139.435 133.981 M124.580 135.250 C 124.562 138.244,124.588 138.342,125.014 136.899 C 125.768 134.346,126.016 132.743,125.619 132.989 C 125.415 133.114,125.103 132.958,124.925 132.641 C 124.736 132.308,124.592 133.404,124.580 135.250 M127.600 132.400 C 127.600 132.620,127.753 132.800,127.940 132.800 C 128.127 132.800,129.297 133.833,130.540 135.097 C 131.783 136.360,132.800 137.263,132.800 137.104 C 132.800 136.945,132.215 136.210,131.500 135.472 C 130.785 134.733,129.842 133.650,129.405 133.064 C 128.616 132.007,127.600 131.634,127.600 132.400 M250.264 133.529 C 249.295 134.599,249.451 134.970,250.471 134.020 C 250.950 133.574,251.249 133.115,251.135 133.002 C 251.021 132.888,250.630 133.125,250.264 133.529 M133.743 135.409 C 132.967 136.280,132.915 136.800,133.602 136.800 C 133.895 136.800,134.906 134.772,134.710 134.577 C 134.645 134.511,134.209 134.886,133.743 135.409 M245.221 138.600 C 243.157 140.690,241.616 142.400,241.797 142.400 C 242.143 142.400,249.200 135.348,249.200 135.002 C 249.200 134.601,248.918 134.857,245.221 138.600 M125.600 135.944 C 125.600 136.433,128.094 138.840,128.342 138.591 C 128.421 138.512,127.836 137.780,127.043 136.963 C 126.249 136.146,125.600 135.687,125.600 135.944 M120.493 138.800 C 120.493 139.570,120.575 139.885,120.676 139.500 C 120.776 139.115,120.776 138.485,120.676 138.100 C 120.575 137.715,120.493 138.030,120.493 138.800 M120.416 144.029 C 120.354 144.891,121.780 148.000,122.238 148.000 C 122.547 148.000,122.800 148.180,122.800 148.400 C 122.800 148.620,123.070 148.800,123.400 148.800 C 124.292 148.800,124.126 148.245,123.100 147.795 C 122.605 147.578,121.802 146.590,121.316 145.600 C 120.831 144.610,120.426 143.903,120.416 144.029 M293.754 148.800 C 293.754 151.550,293.818 152.675,293.896 151.300 C 293.974 149.925,293.974 147.675,293.896 146.300 C 293.818 144.925,293.754 146.050,293.754 148.800 M234.800 149.032 C 233.150 150.660,231.941 151.995,232.114 151.997 C 232.537 152.001,238.181 146.448,237.968 146.236 C 237.876 146.145,236.450 147.403,234.800 149.032 M144.800 148.400 C 144.455 148.623,140.048 148.790,134.433 148.794 C 129.062 148.797,124.779 148.913,124.917 149.050 C 125.651 149.785,146.400 149.114,146.400 148.355 C 146.400 147.889,145.555 147.912,144.800 148.400 M209.500 153.618 C 207.575 155.562,206.000 157.324,206.000 157.534 C 206.000 157.743,207.710 156.201,209.800 154.108 C 211.890 152.014,213.600 150.234,213.600 150.151 C 213.600 149.641,212.604 150.483,209.500 153.618 M228.389 155.456 C 226.745 157.137,225.760 158.315,226.200 158.074 C 227.421 157.404,232.106 152.400,231.512 152.400 C 231.438 152.400,230.032 153.775,228.389 155.456 M124.800 156.400 C 124.800 156.620,125.250 156.800,125.800 156.800 C 126.350 156.800,126.800 156.620,126.800 156.400 C 126.800 156.180,126.350 156.000,125.800 156.000 C 125.250 156.000,124.800 156.180,124.800 156.400 M144.000 156.309 C 144.000 156.479,144.594 156.938,145.319 157.328 C 146.045 157.719,146.940 158.525,147.309 159.119 C 147.792 159.899,147.982 160.010,147.989 159.516 C 148.001 158.746,146.077 156.800,145.304 156.800 C 145.027 156.800,144.800 156.620,144.800 156.400 C 144.800 156.180,144.620 156.000,144.400 156.000 C 144.180 156.000,144.000 156.139,144.000 156.309 M122.297 157.537 C 121.355 158.103,120.435 159.511,120.863 159.730 C 120.939 159.769,121.686 159.125,122.525 158.300 C 124.152 156.700,124.082 156.463,122.297 157.537 M201.500 161.619 C 199.575 163.577,198.000 165.345,198.000 165.547 C 198.000 165.749,199.710 164.201,201.800 162.108 C 203.890 160.014,205.600 158.234,205.600 158.151 C 205.600 157.621,204.589 158.476,201.500 161.619 M219.622 164.054 C 217.544 166.224,215.993 168.000,216.174 168.000 C 216.668 168.000,223.600 160.938,223.600 160.435 C 223.600 159.859,223.897 159.588,219.622 164.054 M125.300 160.661 C 124.972 160.796,124.821 161.648,124.860 163.133 C 124.893 164.380,124.987 164.860,125.070 164.200 C 125.476 160.946,124.925 161.200,131.584 161.200 C 138.986 161.200,138.746 160.908,135.937 166.500 C 134.672 169.020,135.434 168.169,137.012 165.300 C 137.829 163.815,138.498 162.198,138.499 161.707 C 138.499 161.216,138.645 160.904,138.822 161.014 C 139.000 161.123,139.247 161.047,139.372 160.845 C 139.610 160.461,126.212 160.286,125.300 160.661 M148.093 170.953 L 148.000 181.306 146.572 182.653 C 145.633 183.538,145.359 184.000,145.772 184.000 C 146.117 184.000,146.400 183.841,146.400 183.647 C 146.400 183.452,146.765 183.198,147.211 183.081 C 147.658 182.964,147.988 182.718,147.946 182.534 C 147.903 182.351,147.994 181.750,148.147 181.200 C 148.300 180.650,148.371 175.790,148.305 170.400 L 148.185 160.600 148.093 170.953 M140.642 166.532 C 140.237 167.229,139.096 169.330,138.106 171.200 C 137.117 173.070,135.953 175.185,135.521 175.900 C 135.088 176.615,134.825 177.200,134.935 177.200 C 135.045 177.200,135.545 176.525,136.046 175.700 C 136.548 174.875,137.057 174.110,137.179 174.000 C 137.301 173.890,138.081 172.422,138.913 170.739 C 141.474 165.553,141.725 165.687,141.537 172.132 C 141.413 176.369,141.242 177.727,140.799 178.000 C 140.483 178.196,140.368 178.501,140.544 178.678 C 141.522 179.655,142.000 177.313,142.000 171.547 C 142.000 165.253,141.804 164.529,140.642 166.532 M124.853 167.850 C 124.824 169.197,124.708 170.908,124.596 171.650 C 124.409 172.889,124.551 172.751,125.060 171.200 C 125.235 170.667,125.310 170.667,125.730 171.200 C 125.990 171.530,126.472 171.860,126.801 171.933 C 127.203 172.022,127.104 171.751,126.500 171.107 C 124.769 169.263,125.844 167.290,128.292 167.821 L 129.400 168.062 128.400 167.513 C 127.576 167.060,127.224 167.055,126.400 167.480 C 125.446 167.972,125.389 167.935,125.153 166.698 C 124.965 165.713,124.893 165.990,124.853 167.850 M196.426 166.952 C 195.830 168.066,196.149 169.418,197.093 169.780 C 197.698 170.012,197.696 169.970,197.078 169.286 C 196.239 168.359,196.202 167.251,197.000 166.945 C 197.330 166.818,197.600 166.554,197.600 166.357 C 197.600 165.669,196.931 166.009,196.426 166.952 M134.414 169.174 C 133.907 170.121,133.884 170.519,134.352 170.230 C 134.705 170.012,135.255 168.400,134.977 168.400 C 134.895 168.400,134.642 168.748,134.414 169.174 M210.812 173.002 C 205.932 177.894,205.593 178.097,204.623 176.711 C 204.188 176.090,204.000 176.006,204.000 176.431 C 204.000 177.264,204.804 178.000,205.714 178.000 C 206.381 178.000,215.600 169.274,215.600 168.643 C 215.600 168.215,215.472 168.331,210.812 173.002 M130.013 169.081 C 130.037 169.701,132.800 172.173,132.806 171.581 C 132.811 171.110,132.876 171.101,133.150 171.534 C 133.423 171.963,133.536 171.944,133.732 171.434 C 133.913 170.961,133.724 170.800,132.987 170.800 C 132.444 170.800,131.994 170.665,131.987 170.500 C 131.981 170.335,131.531 169.877,130.987 169.481 C 130.444 169.086,130.006 168.906,130.013 169.081 M198.006 170.638 C 198.018 171.332,198.711 172.096,199.184 171.939 C 199.493 171.836,199.367 171.513,198.831 171.028 C 198.374 170.614,198.003 170.439,198.006 170.638 M127.606 172.456 C 127.615 173.269,128.250 174.118,128.723 173.949 C 128.962 173.864,128.811 173.397,128.370 172.856 C 127.921 172.306,127.603 172.139,127.606 172.456 M200.000 172.516 C 200.000 172.973,203.150 176.183,203.376 175.957 C 203.490 175.843,202.777 174.959,201.792 173.992 C 200.806 173.025,200.000 172.361,200.000 172.516 M120.368 176.100 C 120.249 176.960,120.310 177.450,120.512 177.248 C 120.705 177.055,120.798 176.381,120.719 175.749 C 120.587 174.691,120.559 174.719,120.368 176.100 M124.840 176.667 C 124.770 178.187,125.231 178.800,126.443 178.800 C 127.907 178.800,127.965 178.096,126.516 177.927 C 125.755 177.838,125.349 177.501,125.156 176.800 C 124.906 175.895,124.876 175.882,124.840 176.667 M131.200 176.377 C 131.200 176.610,131.352 176.800,131.539 176.800 C 132.103 176.800,133.604 178.262,133.326 178.541 C 133.183 178.683,133.257 178.800,133.491 178.800 C 133.724 178.800,134.024 178.515,134.157 178.167 C 134.506 177.259,134.477 177.200,133.689 177.200 C 133.298 177.200,132.578 176.920,132.089 176.577 C 131.591 176.228,131.200 176.140,131.200 176.377 M128.800 178.400 C 128.800 178.620,129.250 178.800,129.800 178.800 C 130.350 178.800,130.800 178.620,130.800 178.400 C 130.800 178.180,130.350 178.000,129.800 178.000 C 129.250 178.000,128.800 178.180,128.800 178.400 M136.000 178.400 C 136.000 178.620,136.450 178.800,137.000 178.800 C 137.550 178.800,138.000 178.620,138.000 178.400 C 138.000 178.180,137.550 178.000,137.000 178.000 C 136.450 178.000,136.000 178.180,136.000 178.400 M189.722 178.599 C 189.224 179.140,187.933 182.000,188.186 182.000 C 188.386 182.000,190.438 178.303,190.306 178.180 C 190.248 178.125,189.985 178.314,189.722 178.599 M193.000 179.600 C 193.398 180.040,193.769 180.400,193.825 180.400 C 193.880 180.400,193.831 180.040,193.716 179.600 C 193.601 179.160,193.230 178.800,192.891 178.800 C 192.374 178.800,192.391 178.927,193.000 179.600 M121.019 181.400 C 121.151 182.060,121.429 182.661,121.637 182.736 C 121.844 182.810,122.283 183.140,122.611 183.468 C 122.939 183.796,123.431 183.983,123.704 183.885 C 123.991 183.780,123.760 183.498,123.154 183.213 C 122.578 182.942,121.809 182.153,121.444 181.460 L 120.780 180.200 121.019 181.400 M195.034 181.796 C 195.632 182.709,195.633 182.812,195.043 183.039 C 194.345 183.307,194.160 184.000,194.786 184.000 C 194.998 184.000,195.365 183.640,195.600 183.200 C 196.060 182.341,195.531 180.800,194.777 180.800 C 194.559 180.800,194.675 181.248,195.034 181.796 M0.233 186.470 C 0.057 187.938,-0.001 189.378,0.103 189.670 C 0.364 190.396,0.914 185.980,0.713 184.771 C 0.625 184.237,0.408 185.001,0.233 186.470 M192.000 184.410 C 192.000 184.635,191.505 185.017,190.900 185.258 C 190.199 185.537,189.997 185.768,190.343 185.895 C 190.642 186.005,191.358 185.624,191.934 185.048 C 192.510 184.471,192.761 184.000,192.491 184.000 C 192.221 184.000,192.000 184.184,192.000 184.410 M185.726 186.800 C 185.797 187.754,187.600 188.613,187.600 187.692 C 187.600 187.492,188.073 187.113,188.652 186.849 C 189.230 186.586,189.602 186.268,189.478 186.144 C 189.353 186.020,188.840 186.207,188.337 186.559 C 187.139 187.398,186.109 187.373,185.855 186.500 C 185.738 186.096,185.683 186.222,185.726 186.800 M399.714 188.200 C 399.717 189.300,399.795 189.703,399.887 189.095 C 399.979 188.486,399.977 187.586,399.882 187.095 C 399.787 186.603,399.711 187.100,399.714 188.200 M127.050 190.320 C 126.886 190.584,126.258 190.800,125.653 190.800 C 125.048 190.800,124.204 191.083,123.776 191.430 C 123.030 192.035,123.039 192.047,124.000 191.747 C 125.595 191.248,143.664 191.104,144.146 191.586 C 144.374 191.814,144.839 191.999,145.180 191.998 C 145.521 191.996,145.284 191.726,144.654 191.398 C 143.750 190.926,141.836 190.800,135.588 190.800 C 129.780 190.800,127.624 190.672,127.507 190.320 C 127.382 189.946,127.281 189.946,127.050 190.320 M121.700 192.693 C 121.026 193.146,120.810 193.662,120.841 194.749 L 120.882 196.200 121.207 194.820 C 121.386 194.060,121.849 193.207,122.237 192.924 C 123.254 192.180,122.771 191.972,121.700 192.693 M146.400 192.237 C 146.400 192.367,146.760 192.931,147.200 193.491 C 147.647 194.059,147.994 194.263,147.987 193.954 C 147.966 193.024,146.400 191.330,146.400 192.237 M148.130 204.400 L 148.168 214.200 148.384 205.800 C 148.503 201.180,148.486 196.770,148.346 196.000 C 148.206 195.230,148.109 199.010,148.130 204.400 M124.981 196.132 C 124.853 196.645,124.818 197.860,124.904 198.832 C 125.047 200.450,125.066 200.404,125.130 198.300 C 125.169 197.035,125.380 196.000,125.600 196.000 C 125.820 196.000,126.000 195.820,126.000 195.600 C 126.000 194.808,125.210 195.221,124.981 196.132 M137.800 195.600 C 137.936 195.820,138.307 196.000,138.624 196.000 C 138.941 196.000,139.200 195.820,139.200 195.600 C 139.200 195.380,138.829 195.200,138.376 195.200 C 137.923 195.200,137.664 195.380,137.800 195.600 M137.596 197.700 C 137.160 198.415,136.817 199.270,136.833 199.600 C 136.860 200.133,136.887 200.133,137.082 199.600 C 137.202 199.270,137.652 198.415,138.083 197.700 C 138.513 196.985,138.758 196.400,138.627 196.400 C 138.496 196.400,138.032 196.985,137.596 197.700 M140.600 201.200 C 139.909 202.537,140.027 202.715,140.977 201.766 C 141.555 201.188,141.605 201.591,141.547 206.375 C 141.512 209.258,141.600 211.733,141.742 211.875 C 141.884 212.017,142.000 209.403,142.000 206.067 C 142.000 199.831,141.753 198.971,140.600 201.200 M135.431 201.951 C 134.190 203.917,132.890 207.007,133.802 205.824 C 134.131 205.396,134.400 204.909,134.400 204.741 C 134.400 204.573,134.935 203.527,135.590 202.418 C 136.984 200.053,136.860 199.688,135.431 201.951 M219.200 200.700 C 219.200 200.865,222.423 201.000,226.362 201.000 C 230.301 201.000,233.440 200.865,233.338 200.700 C 233.236 200.535,230.013 200.400,226.176 200.400 C 222.339 200.400,219.200 200.535,219.200 200.700 M214.928 201.739 C 212.534 202.399,212.405 202.774,214.755 202.245 C 215.843 202.000,216.869 201.665,217.034 201.500 C 217.414 201.120,217.010 201.166,214.928 201.739 M236.800 201.609 C 236.800 201.767,237.702 202.017,238.805 202.163 C 239.908 202.309,241.123 202.539,241.505 202.673 C 241.979 202.840,242.073 202.786,241.800 202.503 C 241.320 202.006,236.800 201.198,236.800 201.609 M125.600 202.513 C 124.762 203.193,124.542 206.000,125.326 206.000 C 125.650 206.000,126.018 206.270,126.145 206.600 C 126.271 206.930,126.651 207.200,126.987 207.200 C 127.324 207.200,127.600 207.410,127.600 207.667 C 127.600 207.923,127.705 208.029,127.832 207.901 C 128.200 207.533,127.230 206.000,126.629 206.000 C 125.506 206.000,125.263 203.835,126.262 202.731 C 127.002 201.914,126.530 201.758,125.600 202.513 M129.871 203.900 C 130.932 204.945,131.853 205.687,131.917 205.550 C 132.089 205.181,128.940 202.000,128.402 202.000 C 128.148 202.000,128.809 202.855,129.871 203.900 M137.636 206.610 C 136.516 208.705,135.600 210.595,135.600 210.810 C 135.600 211.024,135.398 211.200,135.151 211.200 C 134.827 211.200,134.832 211.356,135.168 211.761 C 135.525 212.192,135.514 212.365,135.117 212.505 C 134.833 212.606,135.950 212.609,137.600 212.512 C 141.644 212.275,142.028 212.070,138.500 212.032 C 136.905 212.014,135.600 211.937,135.600 211.860 C 135.600 211.144,136.577 209.218,137.028 209.045 C 137.343 208.924,137.600 208.500,137.600 208.102 C 137.600 207.704,137.878 206.982,138.217 206.497 C 138.914 205.503,140.101 202.800,139.841 202.800 C 139.748 202.800,138.755 204.514,137.636 206.610 M209.500 203.829 C 208.052 204.615,208.100 204.863,209.600 204.340 C 210.260 204.110,210.800 203.759,210.800 203.561 C 210.800 203.113,210.830 203.107,209.500 203.829 M244.800 203.575 C 244.800 203.735,245.617 204.052,246.614 204.280 C 247.612 204.509,248.321 204.587,248.188 204.455 C 247.774 204.041,244.800 203.269,244.800 203.575 M206.668 205.480 C 205.057 206.326,199.747 211.788,199.471 212.882 C 199.274 213.663,199.311 213.705,199.720 213.165 C 199.984 212.816,200.650 211.933,201.200 211.204 C 202.445 209.554,203.528 208.455,205.032 207.316 C 208.334 204.817,208.691 204.417,206.668 205.480 M250.576 205.813 C 251.004 206.136,251.544 206.394,251.776 206.387 C 252.009 206.380,251.851 206.110,251.424 205.787 C 250.996 205.464,250.456 205.206,250.224 205.213 C 249.991 205.220,250.149 205.490,250.576 205.813 M124.800 209.933 C 124.800 211.070,124.958 212.000,125.151 212.000 C 125.471 212.000,125.287 208.420,124.947 208.033 C 124.866 207.942,124.800 208.797,124.800 209.933 M128.873 209.000 C 129.123 209.550,129.530 210.000,129.775 210.000 C 130.198 210.000,131.600 211.386,131.600 211.805 C 131.600 211.912,130.400 212.000,128.933 212.000 C 125.551 212.000,125.776 212.223,129.455 212.518 C 132.846 212.789,132.975 212.376,130.350 209.644 C 128.520 207.739,128.243 207.619,128.873 209.000 M0.086 210.400 C 0.071 211.610,0.203 213.410,0.380 214.400 L 0.700 216.200 0.710 214.400 C 0.716 213.410,0.584 211.610,0.417 210.400 L 0.113 208.200 0.086 210.400 M224.263 211.900 C 224.162 212.065,225.125 212.200,226.402 212.200 C 227.679 212.200,228.641 212.065,228.538 211.900 C 228.436 211.735,227.474 211.600,226.400 211.600 C 225.326 211.600,224.364 211.735,224.263 211.900 M218.120 213.242 C 217.068 213.547,215.894 214.400,216.528 214.400 C 216.921 214.400,219.600 213.175,219.600 212.995 C 219.600 212.888,219.555 212.816,219.500 212.836 C 219.445 212.856,218.824 213.039,218.120 213.242 M234.268 213.211 C 234.764 213.681,237.600 214.382,237.600 214.035 C 237.600 213.870,236.776 213.546,235.768 213.316 C 234.761 213.085,234.086 213.038,234.268 213.211 M198.414 214.773 C 198.187 215.198,197.809 216.053,197.575 216.673 C 196.953 218.320,197.810 217.281,198.542 215.500 C 199.194 213.916,199.114 213.466,198.414 214.773 M214.846 215.105 C 213.516 216.031,211.897 217.731,211.277 218.853 C 210.974 219.402,211.256 219.212,211.948 218.400 C 212.605 217.630,213.830 216.418,214.671 215.706 C 216.312 214.317,216.397 214.027,214.846 215.105 M238.934 215.093 C 239.277 215.648,241.600 216.461,241.600 216.026 C 241.600 215.843,241.285 215.603,240.900 215.492 C 240.515 215.381,239.855 215.150,239.434 214.977 C 238.927 214.770,238.758 214.808,238.934 215.093 M121.213 216.267 C 121.192 217.027,121.658 218.000,122.043 218.000 C 122.567 218.000,122.479 217.458,121.813 216.576 C 121.490 216.149,121.220 216.010,121.213 216.267 M146.918 216.941 C 145.585 218.635,143.795 218.875,133.800 218.698 C 128.740 218.609,124.150 218.399,123.600 218.231 C 122.710 217.959,122.726 217.996,123.746 218.563 C 124.708 219.098,126.490 219.200,134.884 219.200 C 145.541 219.200,146.340 219.068,147.561 217.114 C 148.296 215.937,147.810 215.806,146.918 216.941 M242.800 216.971 C 242.800 217.065,243.385 217.423,244.100 217.766 L 245.400 218.392 244.456 217.596 C 243.582 216.860,242.800 216.564,242.800 216.971 M196.542 218.894 C 195.737 220.196,195.953 234.000,196.778 234.000 C 196.951 234.000,196.945 233.235,196.764 232.300 C 196.326 230.040,196.329 221.788,196.767 219.900 C 197.129 218.342,197.064 218.050,196.542 218.894 M247.382 220.088 C 248.729 221.327,249.268 221.566,250.600 221.518 L 252.200 221.460 250.489 221.307 C 249.344 221.204,248.617 220.896,248.292 220.376 C 248.026 219.949,247.640 219.600,247.435 219.600 C 247.231 219.600,246.771 219.375,246.414 219.100 C 246.057 218.825,246.493 219.270,247.382 220.088 M209.600 224.800 C 209.600 226.560,209.735 228.000,209.900 228.000 C 210.065 228.000,210.200 226.560,210.200 224.800 C 210.200 223.040,210.065 221.600,209.900 221.600 C 209.735 221.600,209.600 223.040,209.600 224.800 M124.400 225.600 C 124.400 225.820,125.210 226.000,126.200 226.000 C 127.190 226.000,128.000 225.820,128.000 225.600 C 128.000 225.380,127.190 225.200,126.200 225.200 C 125.210 225.200,124.400 225.380,124.400 225.600 M144.000 225.600 C 144.000 225.820,144.255 226.000,144.566 226.000 C 144.877 226.000,145.777 226.627,146.566 227.393 C 147.355 228.159,148.000 228.635,148.000 228.451 C 148.000 227.953,146.103 226.000,145.619 226.000 C 145.389 226.000,145.200 225.820,145.200 225.600 C 145.200 225.380,144.930 225.200,144.600 225.200 C 144.270 225.200,144.000 225.380,144.000 225.600 M1.288 227.193 C 1.269 227.849,1.422 228.490,1.627 228.617 C 1.832 228.743,2.000 228.207,2.000 227.424 C 2.000 225.709,1.336 225.494,1.288 227.193 M122.058 226.811 C 121.540 227.243,120.960 228.272,120.768 229.098 C 120.230 231.416,120.388 232.012,121.008 230.000 C 121.342 228.915,122.080 227.763,122.866 227.100 C 123.602 226.479,123.915 226.006,123.585 226.013 C 123.263 226.021,122.576 226.380,122.058 226.811 M148.000 239.881 C 147.890 245.865,147.938 250.623,148.107 250.454 C 148.276 250.285,148.365 245.388,148.306 239.573 L 148.199 229.000 148.000 239.881 M125.500 230.032 C 124.873 230.397,124.808 231.119,124.880 236.920 L 124.960 243.400 125.180 237.132 C 125.301 233.684,125.526 230.739,125.679 230.586 C 126.238 230.030,140.889 230.298,141.252 230.870 C 141.722 231.611,141.685 244.523,141.210 245.774 L 140.820 246.800 133.459 246.800 C 125.632 246.800,125.453 246.757,125.093 244.800 C 124.928 243.905,124.903 243.928,124.854 245.020 C 124.761 247.118,125.086 247.200,133.466 247.200 C 142.853 247.200,142.000 248.118,142.000 238.016 L 142.000 230.380 140.974 229.990 C 139.609 229.471,126.402 229.507,125.500 230.032 M211.332 231.314 C 212.055 232.676,213.686 234.400,214.252 234.400 C 214.532 234.400,214.904 234.638,215.080 234.928 C 215.403 235.463,218.800 236.973,218.800 236.583 C 218.800 236.467,217.974 236.017,216.964 235.585 C 215.955 235.152,214.169 233.814,212.995 232.613 C 211.822 231.411,211.073 230.826,211.332 231.314 M197.858 236.700 C 198.783 238.950,199.339 239.278,198.530 237.097 C 198.144 236.054,197.695 235.200,197.534 235.200 C 197.373 235.200,197.518 235.875,197.858 236.700 M219.600 237.156 C 219.600 237.309,220.963 237.718,222.630 238.066 C 224.296 238.414,225.511 238.561,225.330 238.393 C 224.861 237.958,219.600 236.822,219.600 237.156 M3.200 239.200 C 3.200 239.640,3.380 240.000,3.600 240.000 C 3.820 240.000,4.000 239.640,4.000 239.200 C 4.000 238.760,3.820 238.400,3.600 238.400 C 3.380 238.400,3.200 238.760,3.200 239.200 M227.200 239.176 C 227.200 239.325,228.648 239.723,230.417 240.060 C 232.186 240.397,233.491 240.539,233.317 240.376 C 232.872 239.957,227.200 238.845,227.200 239.176 M199.628 239.900 C 201.650 242.591,206.658 247.139,206.154 245.825 C 206.022 245.481,205.692 245.200,205.421 245.200 C 204.823 245.200,200.000 240.248,200.000 239.635 C 200.000 239.396,199.798 239.200,199.551 239.200 C 199.248 239.200,199.273 239.428,199.628 239.900 M235.200 241.145 C 235.200 241.289,236.451 241.688,237.980 242.032 C 239.509 242.376,240.682 242.533,240.588 242.381 C 240.494 242.228,239.918 241.992,239.308 241.857 C 238.699 241.722,237.525 241.447,236.700 241.247 C 235.875 241.048,235.200 241.002,235.200 241.145 M241.200 243.162 C 241.200 243.352,241.515 243.597,241.900 243.708 C 242.285 243.819,242.960 244.046,243.400 244.213 C 244.595 244.668,243.622 243.846,242.300 243.285 C 241.695 243.027,241.200 242.972,241.200 243.162 M245.200 245.082 C 245.200 245.262,245.548 245.588,245.974 245.805 C 246.400 246.022,247.507 246.822,248.435 247.582 C 249.362 248.341,250.035 248.701,249.929 248.382 C 249.823 248.062,249.339 247.600,248.853 247.356 C 248.368 247.111,247.572 246.553,247.085 246.115 C 245.924 245.071,245.200 244.674,245.200 245.082 M206.986 246.777 C 207.103 246.966,207.745 247.312,208.413 247.545 C 209.081 247.777,209.532 247.813,209.414 247.623 C 209.297 247.434,208.655 247.088,207.987 246.855 C 207.319 246.623,206.868 246.587,206.986 246.777 M211.600 248.792 C 211.600 248.961,212.095 249.200,212.700 249.322 C 213.305 249.444,214.160 249.675,214.600 249.836 C 215.063 250.004,215.262 249.977,215.073 249.771 C 214.614 249.268,211.600 248.419,211.600 248.792 M120.825 250.042 C 120.799 251.127,122.394 253.200,123.256 253.200 C 123.527 253.200,123.276 252.705,122.698 252.100 C 122.119 251.495,121.467 250.550,121.248 250.000 L 120.851 249.000 120.825 250.042 M250.500 249.863 C 250.885 250.303,251.200 250.855,251.200 251.089 C 251.200 251.323,251.481 251.622,251.825 251.754 C 252.538 252.028,251.139 249.844,250.281 249.343 C 250.017 249.189,250.115 249.423,250.500 249.863 M218.672 250.797 C 218.852 250.959,219.958 251.272,221.128 251.493 C 222.298 251.715,223.108 251.764,222.928 251.603 C 222.748 251.441,221.642 251.128,220.472 250.907 C 219.302 250.685,218.492 250.636,218.672 250.797 M146.200 252.234 C 145.540 252.763,145.233 253.197,145.517 253.198 C 146.092 253.200,147.840 251.705,147.571 251.440 C 147.477 251.347,146.860 251.705,146.200 252.234 M226.598 252.796 C 226.698 252.959,227.370 253.191,228.090 253.312 C 228.811 253.433,229.760 253.664,230.200 253.825 C 230.750 254.026,230.875 253.987,230.600 253.701 C 230.135 253.216,226.325 252.355,226.598 252.796 M252.929 253.967 C 253.169 254.865,253.496 255.600,253.655 255.600 C 254.013 255.600,253.348 253.188,252.854 252.694 C 252.655 252.495,252.690 253.068,252.929 253.967 M124.000 253.600 C 124.000 253.820,124.900 254.000,126.000 254.000 C 127.100 254.000,128.000 253.820,128.000 253.600 C 128.000 253.380,127.100 253.200,126.000 253.200 C 124.900 253.200,124.000 253.380,124.000 253.600 M232.958 254.732 C 233.117 254.989,233.557 255.200,233.935 255.200 C 234.313 255.200,235.020 255.479,235.506 255.819 C 236.248 256.339,236.354 256.345,236.166 255.855 C 236.043 255.535,235.522 255.167,235.008 255.038 C 234.495 254.909,233.758 254.682,233.372 254.534 C 232.892 254.350,232.760 254.412,232.958 254.732 M238.143 257.990 C 238.933 258.864,239.694 260.034,239.833 260.590 C 239.973 261.145,240.238 261.600,240.423 261.600 C 240.608 261.600,240.509 261.000,240.202 260.267 C 239.595 258.813,237.637 256.400,237.064 256.400 C 236.868 256.400,237.353 257.115,238.143 257.990 M254.600 264.201 C 254.600 267.349,254.735 269.841,254.900 269.739 C 255.065 269.636,255.200 267.144,255.200 264.200 C 255.200 261.256,255.065 258.764,254.900 258.662 C 254.735 258.561,254.600 261.053,254.600 264.201 M241.000 265.962 C 241.000 267.701,241.135 269.040,241.300 268.938 C 241.465 268.836,241.600 267.413,241.600 265.776 C 241.600 264.139,241.465 262.800,241.300 262.800 C 241.135 262.800,241.000 264.223,241.000 265.962 M11.044 266.729 C 10.932 266.909,11.084 267.527,11.382 268.100 C 11.680 268.674,11.839 269.228,11.735 269.332 C 11.631 269.435,11.767 269.656,12.036 269.822 C 12.403 270.049,12.457 269.784,12.253 268.762 C 12.104 268.013,11.805 267.340,11.588 267.266 C 11.372 267.192,11.297 266.967,11.421 266.766 C 11.545 266.565,11.557 266.400,11.447 266.400 C 11.337 266.400,11.156 266.548,11.044 266.729 M239.857 271.714 C 239.502 273.131,236.174 276.354,234.188 277.205 C 231.864 278.201,231.873 278.557,234.200 277.695 C 235.190 277.328,236.000 276.882,236.000 276.704 C 236.000 276.526,236.453 276.208,237.007 275.997 C 237.561 275.787,238.187 275.161,238.397 274.607 C 238.608 274.053,238.931 273.600,239.116 273.600 C 239.301 273.600,239.752 272.970,240.119 272.200 C 240.487 271.430,240.629 270.800,240.437 270.800 C 240.244 270.800,239.984 271.211,239.857 271.714 M202.800 272.762 C 202.800 272.992,203.340 273.459,204.000 273.800 C 204.660 274.141,205.200 274.338,205.200 274.238 C 205.200 274.137,204.660 273.670,204.000 273.200 C 203.340 272.730,202.800 272.533,202.800 272.762 M253.098 273.700 C 252.991 274.195,252.763 274.960,252.593 275.400 C 252.361 275.997,252.400 276.092,252.748 275.773 C 253.340 275.230,254.052 272.800,253.619 272.800 C 253.440 272.800,253.205 273.205,253.098 273.700 M206.586 275.177 C 206.703 275.366,207.345 275.712,208.013 275.945 C 208.681 276.177,209.132 276.213,209.014 276.023 C 208.897 275.834,208.255 275.488,207.587 275.255 C 206.919 275.023,206.468 274.987,206.586 275.177 M209.601 276.728 C 209.601 276.878,210.591 277.291,211.801 277.648 C 213.010 278.004,214.000 278.160,214.000 277.994 C 214.000 277.829,213.595 277.600,213.100 277.485 C 212.605 277.371,211.615 277.092,210.900 276.866 C 210.185 276.641,209.600 276.578,209.601 276.728 M250.958 278.500 C 250.271 279.850,249.789 280.460,247.845 282.445 C 247.210 283.093,246.785 283.719,246.902 283.835 C 247.216 284.149,250.921 279.760,251.501 278.386 C 252.174 276.792,251.787 276.873,250.958 278.500 M384.041 278.323 C 383.770 278.830,383.636 279.459,383.742 279.722 C 383.853 279.994,383.950 279.912,383.968 279.533 C 383.986 279.167,384.207 278.798,384.460 278.713 C 384.713 278.629,384.833 278.299,384.727 277.981 C 384.584 277.552,384.407 277.640,384.041 278.323 M215.600 278.797 C 215.600 279.122,217.187 279.392,221.600 279.818 C 224.281 280.076,230.731 279.405,231.348 278.803 C 231.540 278.616,230.910 278.653,229.948 278.886 C 227.738 279.420,219.547 279.421,217.300 278.888 C 216.365 278.667,215.600 278.625,215.600 278.797 M16.400 280.381 C 16.400 281.028,18.075 284.458,18.288 284.245 C 18.570 283.963,17.488 281.200,17.096 281.200 C 16.907 281.200,16.856 281.032,16.983 280.828 C 17.109 280.623,17.030 280.342,16.807 280.204 C 16.583 280.066,16.400 280.145,16.400 280.381 M381.423 284.206 C 380.515 286.380,380.676 286.911,381.616 284.840 C 382.055 283.873,382.332 282.998,382.231 282.897 C 382.130 282.796,381.766 283.385,381.423 284.206 M245.695 284.266 C 245.418 284.378,244.988 284.859,244.741 285.335 C 244.320 286.145,244.359 286.138,245.346 285.230 C 245.926 284.697,246.400 284.202,246.400 284.130 C 246.400 283.984,246.393 283.985,245.695 284.266 M195.200 284.561 C 195.200 284.649,195.785 284.917,196.500 285.155 C 197.689 285.552,197.734 285.538,197.024 284.995 C 196.308 284.447,195.200 284.183,195.200 284.561 M18.567 285.147 C 18.682 285.333,18.966 285.986,19.199 286.598 C 19.432 287.210,19.716 287.617,19.831 287.503 C 20.209 287.125,19.539 285.262,18.943 285.034 C 18.622 284.910,18.452 284.961,18.567 285.147 M198.975 286.308 C 199.414 286.747,202.000 287.511,202.000 287.202 C 202.000 287.034,201.265 286.711,200.368 286.483 C 199.470 286.255,198.843 286.177,198.975 286.308 M242.344 286.790 L 241.400 287.581 242.497 287.090 C 243.100 286.821,243.595 286.465,243.597 286.300 C 243.602 285.841,243.371 285.931,242.344 286.790 M379.867 287.067 C 379.720 287.213,379.600 287.586,379.600 287.895 C 379.600 288.361,379.703 288.354,380.200 287.857 C 380.530 287.527,380.800 287.154,380.800 287.029 C 380.800 286.715,380.193 286.740,379.867 287.067 M204.668 288.411 C 205.164 288.881,208.000 289.582,208.000 289.235 C 208.000 289.070,207.176 288.746,206.168 288.516 C 205.161 288.285,204.486 288.238,204.668 288.411 M238.500 288.539 C 237.785 288.774,237.200 289.096,237.200 289.255 C 237.200 289.632,239.624 288.936,240.153 288.407 C 240.633 287.927,240.280 287.955,238.500 288.539 M212.411 290.571 C 213.114 291.274,233.417 291.153,234.080 290.441 C 234.517 289.971,234.473 289.934,233.800 290.208 C 232.612 290.693,218.251 290.915,214.891 290.501 C 212.822 290.246,212.106 290.266,212.411 290.571 M21.214 290.700 C 21.222 290.865,21.486 291.450,21.800 292.000 C 22.396 293.042,22.657 292.334,22.157 291.033 C 21.913 290.396,21.188 290.140,21.214 290.700 M90.195 295.200 C 90.281 296.630,90.543 298.250,90.778 298.800 C 91.155 299.685,91.174 299.638,90.943 298.400 C 90.800 297.630,90.538 296.010,90.360 294.800 L 90.038 292.600 90.195 295.200 M375.988 294.822 C 375.746 295.274,375.636 295.859,375.742 296.122 C 375.852 296.392,375.951 296.308,375.968 295.929 C 375.986 295.559,376.283 294.974,376.629 294.629 C 376.974 294.283,377.071 294.000,376.843 294.000 C 376.615 294.000,376.230 294.370,375.988 294.822 M104.487 297.400 C 104.909 298.892,108.818 305.315,109.121 305.012 C 109.312 304.821,107.157 301.430,106.740 301.267 C 106.553 301.193,106.400 300.900,106.400 300.616 C 106.400 300.331,106.130 299.874,105.800 299.600 C 105.470 299.326,105.200 298.708,105.200 298.227 C 105.200 297.746,104.938 297.004,104.617 296.576 C 104.096 295.881,104.082 295.967,104.487 297.400 M371.061 303.440 C 370.202 304.618,370.521 305.322,371.391 304.171 C 371.888 303.515,372.218 302.373,371.900 302.413 C 371.845 302.419,371.467 302.882,371.061 303.440 M92.004 303.377 C 92.000 304.136,95.026 309.600,95.450 309.600 C 95.569 309.600,95.301 309.011,94.857 308.292 C 94.412 307.572,93.589 305.997,93.028 304.792 C 92.467 303.586,92.006 302.950,92.004 303.377 M274.288 305.300 C 273.698 306.015,273.211 306.760,273.207 306.955 C 273.203 307.150,273.740 306.631,274.400 305.800 C 275.060 304.969,275.600 304.225,275.600 304.145 C 275.600 303.809,275.302 304.072,274.288 305.300 M110.399 306.198 C 110.914 306.748,111.411 307.123,111.502 307.032 C 111.699 306.835,110.118 305.200,109.730 305.200 C 109.582 305.200,109.883 305.649,110.399 306.198 M369.234 306.100 C 368.774 307.316,368.977 307.423,369.933 306.467 C 370.373 306.027,370.628 305.562,370.500 305.433 C 370.037 304.970,369.568 305.217,369.234 306.100 M112.000 307.391 C 112.000 307.476,112.540 307.930,113.200 308.400 C 113.860 308.870,114.399 309.107,114.397 308.927 C 114.396 308.747,113.856 308.293,113.197 307.919 C 112.539 307.544,112.000 307.307,112.000 307.391 M271.855 307.800 C 271.729 308.130,271.279 308.400,270.855 308.400 C 270.432 308.400,269.972 308.696,269.833 309.057 C 269.695 309.419,269.474 309.607,269.343 309.476 C 269.212 309.345,268.843 309.500,268.524 309.819 C 268.204 310.139,267.416 310.400,266.771 310.400 C 266.127 310.400,265.600 310.580,265.600 310.800 C 265.600 311.418,266.855 311.240,268.400 310.403 C 269.170 309.985,270.160 309.474,270.600 309.268 C 271.599 308.798,273.072 307.200,272.505 307.200 C 272.274 307.200,271.982 307.470,271.855 307.800 M368.073 308.487 C 367.813 308.747,367.600 309.179,367.600 309.447 C 367.600 309.714,367.375 310.024,367.100 310.135 C 366.708 310.293,366.711 310.344,367.113 310.368 C 367.394 310.386,367.741 310.085,367.883 309.700 C 368.025 309.315,368.330 308.875,368.559 308.722 C 368.789 308.569,368.880 308.347,368.762 308.228 C 368.643 308.110,368.334 308.226,368.073 308.487 M32.063 309.450 C 32.873 311.192,33.381 312.000,33.665 312.000 C 34.180 312.000,33.038 309.479,32.432 309.277 C 32.139 309.180,31.973 309.257,32.063 309.450 M115.200 309.356 C 115.200 309.523,118.653 311.200,118.996 311.200 C 119.108 311.200,119.200 311.020,119.200 310.800 C 119.200 310.580,118.874 310.400,118.476 310.400 C 118.079 310.400,117.404 310.136,116.976 309.813 C 116.256 309.268,115.200 308.996,115.200 309.356 M158.700 311.500 C 178.115 311.557,209.885 311.557,229.300 311.500 C 248.715 311.443,232.830 311.396,194.000 311.396 C 155.170 311.396,139.285 311.443,158.700 311.500 M34.577 313.500 C 35.192 314.633,36.985 316.914,36.699 316.200 C 35.860 314.109,35.372 313.200,35.089 313.200 C 34.904 313.200,34.864 313.020,35.000 312.800 C 35.136 312.580,34.962 312.400,34.613 312.400 C 34.044 312.400,34.040 312.511,34.577 313.500 M97.601 312.633 C 97.601 312.835,98.141 313.630,98.800 314.400 C 99.459 315.170,99.999 315.905,99.999 316.033 C 100.000 316.162,100.278 316.267,100.618 316.267 C 101.014 316.267,100.620 315.612,99.518 314.441 C 98.573 313.437,97.755 312.537,97.700 312.441 C 97.645 312.345,97.600 312.432,97.601 312.633 M364.513 313.724 C 364.035 314.426,363.530 315.360,363.392 315.800 L 363.140 316.600 363.636 315.800 C 363.908 315.360,364.237 314.910,364.366 314.800 C 364.762 314.461,365.664 312.730,365.519 312.585 C 365.444 312.510,364.991 313.023,364.513 313.724 M101.600 316.724 C 101.600 317.156,104.008 319.326,104.235 319.098 C 104.327 319.006,103.772 318.357,103.001 317.656 C 102.231 316.954,101.600 316.535,101.600 316.724 M38.800 318.953 C 38.800 319.283,38.980 319.664,39.200 319.800 C 39.420 319.936,39.600 319.777,39.600 319.447 C 39.600 319.117,39.420 318.736,39.200 318.600 C 38.980 318.464,38.800 318.623,38.800 318.953 M107.200 320.711 C 107.200 321.402,108.664 322.400,109.631 322.368 C 110.242 322.349,110.378 322.254,110.000 322.111 C 109.670 321.987,108.905 321.539,108.300 321.116 C 107.695 320.692,107.200 320.510,107.200 320.711 M40.819 321.400 C 40.809 321.994,41.523 323.010,41.774 322.759 C 41.894 322.640,41.729 322.195,41.409 321.771 C 41.088 321.347,40.822 321.180,40.819 321.400 M357.600 323.200 C 357.130 323.860,356.925 324.400,357.143 324.400 C 357.362 324.400,357.811 323.860,358.140 323.200 C 358.469 322.540,358.675 322.000,358.597 322.000 C 358.518 322.000,358.070 322.540,357.600 323.200 M112.400 323.252 C 112.950 323.489,113.713 323.844,114.095 324.041 C 114.477 324.239,115.197 324.392,115.695 324.382 C 116.663 324.364,114.520 323.477,112.459 323.044 L 111.400 322.821 112.400 323.252 M118.000 324.900 C 118.000 325.266,263.423 325.226,264.723 324.860 C 265.231 324.717,232.426 324.600,191.823 324.600 C 151.220 324.600,118.000 324.735,118.000 324.900 M45.000 327.200 C 45.804 328.088,46.356 328.311,45.652 327.463 C 45.407 327.168,45.325 326.808,45.470 326.663 C 45.615 326.518,45.405 326.400,45.005 326.400 C 44.301 326.400,44.301 326.428,45.000 327.200 M48.000 330.617 C 48.000 330.736,48.360 331.220,48.800 331.692 C 49.256 332.181,49.600 332.334,49.600 332.047 C 49.600 331.770,49.343 331.286,49.029 330.971 C 48.442 330.385,48.000 330.233,48.000 330.617 M50.013 332.869 C 50.020 333.161,50.660 334.030,51.436 334.800 C 52.408 335.765,52.753 335.951,52.546 335.400 C 52.149 334.340,49.996 332.190,50.013 332.869 M54.000 336.979 C 54.000 337.321,54.180 337.600,54.400 337.600 C 54.620 337.600,54.800 337.840,54.800 338.133 C 54.800 338.427,55.070 338.667,55.400 338.667 C 56.164 338.667,56.178 338.709,55.000 337.438 C 54.293 336.675,54.000 336.541,54.000 336.979 M56.400 339.572 C 56.400 339.776,57.030 340.611,57.800 341.427 C 58.679 342.359,59.200 342.684,59.200 342.299 C 59.200 341.962,58.919 341.578,58.575 341.446 C 58.225 341.311,58.076 341.001,58.236 340.741 C 58.404 340.470,58.350 340.384,58.107 340.534 C 57.878 340.675,57.597 340.433,57.483 339.996 C 57.276 339.205,56.400 338.862,56.400 339.572 M59.600 342.976 C 59.600 343.577,60.318 344.215,60.636 343.897 C 60.915 343.618,60.363 342.400,59.957 342.400 C 59.761 342.400,59.600 342.659,59.600 342.976 M61.200 344.800 C 61.200 345.020,61.470 345.200,61.800 345.200 C 62.130 345.200,62.400 345.020,62.400 344.800 C 62.400 344.580,62.130 344.400,61.800 344.400 C 61.470 344.400,61.200 344.580,61.200 344.800 M65.240 348.440 C 65.851 349.051,66.200 349.160,66.520 348.840 C 66.840 348.520,66.775 348.400,66.280 348.400 C 65.906 348.400,65.600 348.220,65.600 348.000 C 65.600 347.780,65.330 347.600,65.000 347.600 C 64.543 347.600,64.600 347.800,65.240 348.440 M67.800 350.800 C 69.590 352.223,69.583 352.221,69.316 351.200 C 69.200 350.757,68.770 350.400,68.353 350.400 C 67.939 350.400,67.600 350.220,67.600 350.000 C 67.600 349.780,67.305 349.600,66.945 349.600 C 66.528 349.600,66.839 350.037,67.800 350.800 M72.400 354.800 C 72.400 355.020,72.670 355.200,73.000 355.200 C 73.330 355.200,73.600 355.020,73.600 354.800 C 73.600 354.580,73.330 354.400,73.000 354.400 C 72.670 354.400,72.400 354.580,72.400 354.800 M324.000 356.904 C 324.000 357.255,323.685 357.624,323.300 357.724 C 322.644 357.896,322.645 357.910,323.313 357.954 C 324.036 358.001,324.706 356.973,324.249 356.516 C 324.112 356.379,324.000 356.553,324.000 356.904 M80.000 360.736 C 80.000 360.920,80.495 361.320,81.100 361.623 C 82.576 362.363,83.160 362.548,82.300 362.003 C 81.915 361.760,81.597 361.254,81.594 360.880 C 81.589 360.295,81.534 360.284,81.200 360.800 C 80.942 361.200,80.810 361.233,80.806 360.900 C 80.803 360.625,80.620 360.400,80.400 360.400 C 80.180 360.400,80.000 360.551,80.000 360.736 M85.600 364.800 C 85.600 365.020,85.971 365.200,86.424 365.200 C 86.877 365.200,87.136 365.020,87.000 364.800 C 86.864 364.580,86.493 364.400,86.176 364.400 C 85.859 364.400,85.600 364.580,85.600 364.800 M89.309 367.200 C 89.869 367.640,90.521 368.000,90.759 368.000 C 90.997 368.000,90.884 367.640,90.507 367.200 C 90.130 366.760,89.478 366.400,89.057 366.400 C 88.388 366.400,88.419 366.500,89.309 367.200 M309.500 367.233 C 309.115 367.655,308.944 368.000,309.120 368.000 C 309.700 368.000,311.594 367.006,311.597 366.700 C 311.603 366.117,310.191 366.477,309.500 367.233 M101.600 374.586 C 101.600 374.688,101.960 374.965,102.400 375.200 C 103.039 375.542,103.200 375.504,103.200 375.014 C 103.200 374.667,102.853 374.400,102.400 374.400 C 101.960 374.400,101.600 374.484,101.600 374.586 M296.800 375.000 C 296.162 375.769,296.813 375.777,297.824 375.013 C 298.476 374.519,298.496 374.423,297.949 374.413 C 297.591 374.406,297.074 374.670,296.800 375.000 M108.000 377.790 C 108.000 378.100,110.458 379.276,110.667 379.066 C 110.773 378.960,110.487 378.754,110.030 378.610 C 109.574 378.465,109.200 378.178,109.200 377.973 C 109.200 377.768,108.930 377.600,108.600 377.600 C 108.270 377.600,108.000 377.685,108.000 377.790 M286.800 380.000 C 286.800 380.220,287.059 380.400,287.376 380.400 C 287.693 380.400,288.064 380.220,288.200 380.000 C 288.336 379.780,288.077 379.600,287.624 379.600 C 287.171 379.600,286.800 379.780,286.800 380.000 M115.800 382.000 C 115.936 382.220,116.307 382.400,116.624 382.400 C 116.941 382.400,117.200 382.220,117.200 382.000 C 117.200 381.780,116.829 381.600,116.376 381.600 C 115.923 381.600,115.664 381.780,115.800 382.000 M117.600 382.753 C 117.600 383.164,119.052 383.614,119.366 383.301 C 119.483 383.184,119.483 382.934,119.366 382.744 C 119.085 382.291,117.600 382.299,117.600 382.753 M280.678 382.656 C 280.215 383.118,280.785 383.529,281.596 383.317 C 282.033 383.203,282.292 382.950,282.172 382.755 C 281.917 382.342,281.048 382.285,280.678 382.656 M133.200 388.753 C 133.200 388.948,133.570 389.204,134.023 389.322 C 134.698 389.498,134.761 389.435,134.374 388.969 C 133.846 388.332,133.200 388.214,133.200 388.753 M135.600 389.753 C 135.600 389.838,136.050 389.993,136.600 390.098 C 137.150 390.203,137.600 390.134,137.600 389.945 C 137.600 389.755,137.150 389.600,136.600 389.600 C 136.050 389.600,135.600 389.669,135.600 389.753 M253.000 392.800 C 252.864 393.020,253.023 393.200,253.353 393.200 C 253.683 393.200,254.064 393.020,254.200 392.800 C 254.336 392.580,254.177 392.400,253.847 392.400 C 253.517 392.400,253.136 392.580,253.000 392.800 M153.679 394.612 C 153.796 394.729,154.501 394.993,155.246 395.199 C 156.485 395.542,156.534 395.525,155.824 394.987 C 155.117 394.453,153.181 394.114,153.679 394.612 M245.000 394.800 C 244.229 395.131,244.231 395.145,245.076 395.172 C 245.558 395.187,246.064 395.020,246.200 394.800 C 246.492 394.327,246.101 394.327,245.000 394.800 M157.284 395.818 C 157.725 396.258,159.557 396.394,159.798 396.003 C 159.948 395.760,159.456 395.600,158.557 395.600 C 157.737 395.600,157.165 395.698,157.284 395.818 M239.830 395.990 C 240.071 396.231,240.673 396.244,241.410 396.024 C 242.586 395.673,242.581 395.668,241.020 395.634 C 239.995 395.612,239.577 395.737,239.830 395.990 M163.300 397.076 C 163.685 397.176,164.315 397.176,164.700 397.076 C 165.085 396.975,164.770 396.893,164.000 396.893 C 163.230 396.893,162.915 396.975,163.300 397.076 M235.300 397.076 C 235.685 397.176,236.315 397.176,236.700 397.076 C 237.085 396.975,236.770 396.893,236.000 396.893 C 235.230 396.893,234.915 396.975,235.300 397.076 M168.400 397.879 C 168.400 398.056,168.895 398.210,169.500 398.223 C 170.105 398.236,170.997 398.326,171.482 398.423 C 171.967 398.520,172.417 398.420,172.482 398.200 C 172.547 397.979,171.659 397.746,170.500 397.679 C 169.345 397.613,168.400 397.703,168.400 397.879 M228.000 397.974 C 228.000 398.180,228.810 398.322,229.800 398.289 C 230.790 398.257,231.600 398.089,231.600 397.915 C 231.600 397.742,230.790 397.600,229.800 397.600 C 228.810 397.600,228.000 397.768,228.000 397.974 M176.505 399.087 C 177.114 399.179,178.014 399.177,178.505 399.082 C 178.997 398.987,178.500 398.911,177.400 398.914 C 176.300 398.917,175.897 398.995,176.505 399.087 M221.900 399.082 C 222.395 399.178,223.205 399.178,223.700 399.082 C 224.195 398.987,223.790 398.909,222.800 398.909 C 221.810 398.909,221.405 398.987,221.900 399.082 M186.900 399.887 C 187.505 399.978,188.495 399.978,189.100 399.887 C 189.705 399.795,189.210 399.720,188.000 399.720 C 186.790 399.720,186.295 399.795,186.900 399.887 M211.305 399.887 C 211.914 399.979,212.814 399.977,213.305 399.882 C 213.797 399.787,213.300 399.711,212.200 399.714 C 211.100 399.717,210.697 399.795,211.305 399.887 ",
                    fill: '#e59438',
                    stroke: 'none',
                    'fill-rule': 'evenodd'
                }
            ),
            el(
                'path',
                { 
                    d: "M169.884 2.080 C 169.589 2.268,169.820 2.390,170.476 2.394 C 171.068 2.397,171.657 2.231,171.785 2.024 C 172.056 1.586,170.594 1.629,169.884 2.080 M340.000 57.000 C 340.000 57.330,340.292 57.600,340.649 57.600 C 341.180 57.600,341.208 57.491,340.800 57.000 C 340.526 56.670,340.234 56.400,340.151 56.400 C 340.068 56.400,340.000 56.670,340.000 57.000 M349.308 66.401 C 349.698 66.648,349.924 66.999,349.811 67.183 C 349.697 67.366,349.898 67.629,350.257 67.766 C 350.843 67.992,350.850 67.928,350.320 67.130 C 349.996 66.643,349.477 66.179,349.166 66.099 C 348.855 66.019,348.919 66.155,349.308 66.401 M362.108 82.437 C 362.498 82.664,362.712 83.018,362.585 83.225 C 362.457 83.431,362.543 83.600,362.776 83.600 C 363.009 83.600,363.200 83.456,363.200 83.280 C 363.200 82.815,362.310 81.998,361.820 82.012 C 361.589 82.019,361.719 82.210,362.108 82.437 M293.600 223.930 C 293.600 302.172,293.720 298.521,290.924 305.074 C 286.385 315.713,278.075 322.614,267.808 324.272 C 263.661 324.941,263.475 325.024,265.271 325.406 C 266.002 325.562,266.870 325.909,267.200 326.177 C 267.701 326.585,270.738 328.165,279.083 332.362 C 279.697 332.671,280.290 333.031,280.400 333.162 C 280.510 333.293,282.040 334.089,283.800 334.931 C 285.560 335.773,287.270 336.629,287.600 336.833 C 287.930 337.037,289.820 338.012,291.800 339.000 C 295.621 340.906,297.686 342.034,300.069 343.514 C 300.878 344.017,302.092 344.466,302.769 344.514 C 303.445 344.561,303.999 344.812,303.999 345.071 C 304.000 345.330,304.945 346.000,306.100 346.560 C 307.255 347.121,308.470 347.752,308.800 347.962 C 309.130 348.173,310.975 349.082,312.900 349.984 C 314.825 350.885,316.400 351.798,316.400 352.011 C 316.400 352.225,316.679 352.400,317.020 352.400 C 317.671 352.400,320.057 353.518,320.400 353.983 C 320.772 354.489,324.050 355.616,324.442 355.374 C 324.680 355.227,324.731 355.536,324.573 356.166 C 324.157 357.821,324.646 357.580,327.633 354.658 C 328.275 354.029,328.800 353.652,328.800 353.820 C 328.800 353.987,329.205 353.670,329.700 353.114 C 330.195 352.559,331.093 351.791,331.697 351.408 C 332.300 351.026,332.677 350.524,332.535 350.294 C 332.393 350.065,332.452 349.985,332.667 350.118 C 332.882 350.251,334.254 349.199,335.715 347.780 C 337.177 346.361,338.559 345.200,338.786 345.200 C 339.014 345.200,339.200 344.926,339.200 344.591 C 339.200 344.257,339.650 343.778,340.200 343.527 C 340.750 343.277,341.200 342.908,341.200 342.707 C 341.200 342.236,342.236 341.200,342.707 341.200 C 342.908 341.200,343.277 340.750,343.527 340.200 C 343.778 339.650,344.257 339.200,344.591 339.200 C 344.926 339.200,345.155 339.040,345.100 338.844 C 345.045 338.647,345.422 338.117,345.937 337.665 C 346.490 337.179,346.751 336.645,346.575 336.359 C 346.396 336.070,346.445 335.980,346.696 336.136 C 346.927 336.279,347.219 336.126,347.346 335.798 C 347.472 335.469,347.851 335.200,348.187 335.200 C 348.524 335.200,348.800 335.023,348.800 334.807 C 348.800 334.591,349.430 333.766,350.200 332.973 C 350.970 332.180,351.600 331.187,351.600 330.766 C 351.600 330.329,351.876 330.000,352.243 330.000 C 352.738 330.000,352.826 329.757,352.624 328.952 C 352.381 327.985,352.411 327.954,353.009 328.552 C 353.701 329.244,354.185 329.423,353.836 328.859 C 353.720 328.671,353.903 328.176,354.242 327.759 C 354.582 327.342,354.721 327.270,354.553 327.600 C 354.290 328.115,354.341 328.123,354.919 327.655 C 355.289 327.355,355.497 326.958,355.383 326.772 C 355.268 326.587,355.639 326.131,356.207 325.758 C 356.775 325.386,357.157 324.866,357.056 324.602 C 356.955 324.338,357.261 323.682,357.736 323.142 C 358.211 322.603,358.443 322.396,358.251 322.681 C 358.031 323.008,358.072 323.200,358.361 323.200 C 358.613 323.200,358.929 322.656,359.062 321.992 C 359.194 321.328,359.798 320.368,360.404 319.858 C 361.760 318.717,362.303 317.238,361.543 316.756 C 361.125 316.492,361.118 316.411,361.513 316.406 C 361.795 316.403,362.178 316.805,362.365 317.300 C 362.672 318.114,362.748 318.040,363.163 316.517 C 363.424 315.559,363.832 314.884,364.111 314.951 C 364.380 315.016,364.465 314.993,364.300 314.901 C 363.873 314.662,363.927 313.600,364.367 313.600 C 364.568 313.600,364.837 313.825,364.963 314.100 C 365.089 314.375,365.092 314.194,364.969 313.698 C 364.819 313.095,364.953 312.716,365.372 312.555 C 365.718 312.423,366.000 312.073,366.000 311.777 C 366.000 311.482,366.315 311.056,366.700 310.832 C 367.085 310.608,367.220 310.416,367.000 310.406 C 366.733 310.394,366.733 310.290,367.000 310.094 C 367.220 309.932,367.608 309.440,367.863 309.000 C 368.117 308.560,368.545 308.253,368.814 308.317 C 369.135 308.394,369.223 308.132,369.072 307.552 C 368.809 306.550,369.283 305.503,370.668 304.023 C 371.194 303.460,371.724 302.550,371.846 302.000 C 372.213 300.341,372.363 299.990,372.689 300.044 C 373.550 300.185,373.952 299.940,373.745 299.400 C 373.597 299.016,373.752 298.800,374.175 298.800 C 374.582 298.800,374.790 298.531,374.718 298.100 C 374.652 297.709,374.821 297.444,375.100 297.500 C 375.375 297.555,375.579 297.465,375.553 297.300 C 375.381 296.211,375.713 295.087,376.415 294.385 C 376.863 293.937,377.122 293.397,376.991 293.185 C 376.860 292.973,377.033 292.800,377.376 292.800 C 377.719 292.800,378.000 292.505,378.000 292.144 C 378.000 291.783,378.280 291.283,378.622 291.033 C 379.254 290.571,379.514 289.755,379.569 288.063 C 379.588 287.497,379.899 287.047,380.354 286.928 C 380.887 286.788,381.044 286.490,380.891 285.903 C 380.771 285.448,380.837 285.176,381.037 285.299 C 381.237 285.422,381.428 285.055,381.463 284.484 C 381.497 283.912,381.812 283.234,382.163 282.978 C 382.513 282.722,382.800 282.206,382.800 281.832 C 382.800 281.459,382.943 281.241,383.117 281.349 C 383.291 281.456,383.476 280.997,383.527 280.328 C 383.638 278.874,384.310 277.497,384.770 277.782 C 384.952 277.894,385.100 277.530,385.100 276.973 C 385.100 276.417,385.438 275.687,385.850 275.351 C 386.263 275.015,386.375 274.855,386.100 274.994 C 385.825 275.133,385.600 275.076,385.600 274.866 C 385.600 274.657,385.910 274.367,386.289 274.221 C 386.879 273.995,386.893 273.904,386.389 273.585 C 385.923 273.290,385.914 273.211,386.347 273.206 C 386.695 273.202,386.818 272.910,386.684 272.400 C 386.545 271.869,386.672 271.600,387.061 271.600 C 387.383 271.600,387.544 271.432,387.417 271.228 C 387.291 271.023,387.381 270.735,387.618 270.589 C 388.351 270.136,389.053 267.792,389.414 264.600 C 389.602 262.927,389.619 262.903,389.965 263.789 C 390.242 264.499,390.293 264.471,390.479 263.501 C 390.617 262.779,390.539 262.511,390.242 262.689 C 389.999 262.834,390.064 262.629,390.386 262.233 C 391.041 261.426,391.344 260.111,391.378 257.938 C 391.390 257.134,391.499 256.537,391.619 256.612 C 392.195 256.968,392.790 256.002,392.989 254.386 C 393.424 250.865,393.685 249.892,394.046 250.460 C 394.303 250.866,394.397 250.802,394.424 250.200 C 394.445 249.760,394.527 249.130,394.607 248.800 C 394.687 248.470,394.968 247.030,395.231 245.600 C 395.495 244.170,395.846 242.910,396.010 242.800 C 396.175 242.690,396.613 240.350,396.984 237.600 C 397.355 234.850,397.824 232.240,398.026 231.800 C 398.433 230.912,399.397 221.561,399.829 214.300 C 400.098 209.773,400.079 209.600,399.308 209.600 C 398.868 209.600,398.050 209.240,397.491 208.800 C 396.931 208.360,396.341 208.000,396.179 208.000 C 395.757 208.000,389.599 204.837,385.600 202.566 C 381.936 200.486,375.781 197.226,371.600 195.150 C 370.170 194.440,368.443 193.441,367.762 192.929 C 367.081 192.418,366.361 192.005,366.162 192.011 C 365.597 192.029,360.736 189.480,359.847 188.700 C 359.408 188.315,358.816 188.000,358.531 188.000 C 358.245 188.000,357.134 187.460,356.062 186.800 C 354.989 186.140,353.908 185.600,353.659 185.600 C 353.410 185.600,352.982 185.240,352.707 184.800 C 352.432 184.360,351.887 184.000,351.495 184.000 C 350.524 184.000,344.400 180.889,344.400 180.396 C 344.400 180.178,344.051 180.000,343.624 180.000 C 343.197 180.000,342.748 179.840,342.627 179.644 C 342.506 179.449,341.913 179.164,341.308 179.013 C 340.703 178.861,340.113 178.583,339.996 178.394 C 339.880 178.206,337.268 176.759,334.192 175.178 C 331.117 173.597,328.420 172.170,328.200 172.006 C 327.723 171.650,319.998 167.557,316.600 165.859 C 315.280 165.199,314.110 164.556,314.000 164.430 C 313.676 164.057,312.409 163.372,308.800 161.615 C 306.930 160.705,305.130 159.795,304.800 159.594 C 304.470 159.392,303.030 158.642,301.600 157.926 C 300.170 157.211,298.910 156.530,298.800 156.413 C 298.376 155.962,296.785 155.200,296.267 155.200 C 295.969 155.200,295.398 154.840,295.000 154.400 C 294.602 153.960,294.124 153.600,293.938 153.600 C 293.752 153.600,293.600 185.248,293.600 223.930 M397.887 224.695 C 397.795 225.303,397.717 224.900,397.714 223.800 C 397.711 222.700,397.787 222.203,397.882 222.695 C 397.977 223.186,397.979 224.086,397.887 224.695 M396.400 236.200 C 396.400 236.750,396.220 237.200,396.000 237.200 C 395.780 237.200,395.600 236.750,395.600 236.200 C 395.600 235.650,395.780 235.200,396.000 235.200 C 396.220 235.200,396.400 235.650,396.400 236.200 M386.400 265.000 C 386.400 265.550,386.220 266.000,386.000 266.000 C 385.780 266.000,385.600 265.550,385.600 265.000 C 385.600 264.450,385.780 264.000,386.000 264.000 C 386.220 264.000,386.400 264.450,386.400 265.000 M374.394 296.700 C 374.376 297.577,373.612 298.159,373.606 297.300 C 373.603 296.805,373.780 296.400,374.000 296.400 C 374.220 296.400,374.397 296.535,374.394 296.700 M36.800 316.800 C 36.800 317.020,36.991 317.200,37.224 317.200 C 37.457 317.200,37.519 317.408,37.362 317.662 C 37.189 317.941,37.252 318.015,37.521 317.849 C 37.765 317.698,37.864 317.310,37.740 316.987 C 37.485 316.324,36.800 316.188,36.800 316.800 M318.000 361.433 C 317.444 361.742,317.267 361.985,317.600 361.980 C 317.930 361.975,318.650 361.714,319.200 361.400 C 319.750 361.086,319.930 360.840,319.600 360.853 C 319.270 360.867,318.550 361.128,318.000 361.433 M129.770 387.952 C 129.890 388.145,130.395 388.406,130.894 388.532 C 131.768 388.752,131.773 388.740,131.024 388.180 C 130.164 387.538,129.432 387.404,129.770 387.952 M241.600 396.000 L 240.600 396.320 241.700 396.360 C 242.305 396.382,242.800 396.220,242.800 396.000 C 242.800 395.780,242.755 395.618,242.700 395.640 C 242.645 395.662,242.150 395.824,241.600 396.000 ",
                    fill: '#c26f18',
                    stroke: 'none',
                    'fill-rule': 'evenodd'
                }
            )
        )
    );

   var surveyMakerMapSelectToProps = function( select ) {
       if(select( 'core/blocks' ).getBlockType( 'survey-maker/survey' ).attributes.idner &&
          (select( 'core/blocks' ).getBlockType( 'survey-maker/survey' ).attributes.idner != undefined ||
           select( 'core/blocks' ).getBlockType( 'survey-maker/survey' ).attributes.idner != null ) ){
           return {
               surveys: select( 'core/blocks' ).getBlockType( 'survey-maker/survey' ).attributes.idner,
               metaFieldValue: select( 'core/editor' )
                   .getEditedPostAttribute( 'meta' )
                   [ 'sidebar_plugin_meta_block_field' ]
           };
       }else{
           return {
               surveys: __( "Something goes wrong please reload page" )
           };
       }
   }

    var supports = {
        customClassName: false
    };

    var keywords = new Array('Questionnaire', 'Feedback', 'Statistics', 'Data', 'Survey');

    registerBlockType( 'survey-maker/survey', {
        title: __('Survey Maker'),
        category: 'common',
        icon: iconEl,
        supports: supports,
        keywords: keywords,
        edit: withSelect( function( select ) {
            if(select( 'core/blocks' ).getBlockType( 'survey-maker/survey' ).attributes.idner &&
               (select( 'core/blocks' ).getBlockType( 'survey-maker/survey' ).attributes.idner != undefined ||
                select( 'core/blocks' ).getBlockType( 'survey-maker/survey' ).attributes.idner != null ) ){
                return {
                    surveys: select( 'core/blocks' ).getBlockType( 'survey-maker/survey' ).attributes.idner
                };
            }else{
                return {
                    surveys: __( "Something goes wrong please reload page" )
                };
            }
        } )( function( props ) {

            if ( ! props.surveys ) {
                return __("Loading...");
            }
            if( typeof props.surveys != "object"){
                return props.surveys;
            }

            if ( props.surveys.length === 0 ) {
                return __("There are no surveys yet");
            }
            var status = 0;
            if(props.attributes.metaFieldValue > 0){            
                status = 1;
            }
            
            var surveyner = [];
            surveyner.push({ label: __("Select survey"), value: ''});
            for(var i in props.surveys){
                var surveyData = {
                        value: props.surveys[i].id,
                        label: props.surveys[i].title,
                    }
                surveyner.push(surveyData)
            }

            var aysElement = el(
                aysSelect, {
                    className: 'ays_survey_maker_block_select',
                    label: 'Select survey',
                    value: props.attributes.metaFieldValue,
                    onChange: function( content ) {
                        var c = content;
                        var shortcodeText = '';
                        if(isNaN(content)){
                            c = '';
                        }

                        if( c != '' ){
                            shortcodeText = "[ays_survey id="+c+"]";
                        }else{
                            shortcodeText = '';
                            c = 0;
                        }
                        status = 1;
                        wp.data.dispatch( 'core/block-editor' ).updateBlockAttributes( props.clientId, {
                            shortcode: shortcodeText,
                            metaFieldValue: parseInt(c)
                        } );
                    },
                    options: surveyner
                }
            );

            var aysElement2 = el(
                aysSelect, {
                    className: 'ays_survey_maker_block_select',
                    label: '',
                    value: props.attributes.metaFieldValue,
                    onChange: function( content ) {
                        var c = content;
                        var shortcodeText = '';
                        if(isNaN(content)){
                            c = '';
                        }
                        if( c != '' ){
                            shortcodeText = "[ays_survey id="+c+"]";
                        }else{
                            shortcodeText = '';
                            c = 0;
                        }
                        wp.data.dispatch( 'core/block-editor' ).updateBlockAttributes( props.clientId, {
                            shortcode: shortcodeText,
                            metaFieldValue: parseInt(c)
                        } );
                    },
                    options: surveyner
                },
            );
            
            var res = el(
                wp.element.Fragment,
                {},
                el(
                    BlockControls,
                    props
                ),
                el(
                    wp.blockEditor.InspectorControls,
                    {},
                    el(
                        wp.components.PanelBody,
                        {},
                        el(
                            "div",
                            {
                                className: 'ays_survey_maker_block_container',
                                key: "inspector",
                            },
                            aysElement
                        )
                    )
                ),
                el(ServerSideRender, {
                    key: "editable",
                    block: "survey-maker/survey",
                    attributes:  props.attributes
                }),
                el(
                    "div",
                    {
                        className: 'ays_survey_maker_block_select_survey',
                        key: "inspector",
                    },
                    aysElement2
                )
                );
            var res2 = el(
                wp.element.Fragment,
                {},
                el(
                    BlockControls,
                    props
                ),
                el(
                    wp.blockEditor.InspectorControls,
                    {},
                    el(
                        wp.components.PanelBody,
                        {},
                        el(
                            "div",
                            {
                                className: 'ays_survey_maker_block_container',
                                key: "inspector",
                            },
                            aysElement
                        )
                    )
                ),
                el(ServerSideRender, {
                    key: "editable",
                    block: "survey-maker/survey",
                    attributes: props.attributes
                })
            );
            if(status == 1){
                return res2;
            }else{
                return res;
            }
        }),

        save: function(e) {
            var t = e.attributes,
                n = parseInt( t.metaFieldValue );

            if(isNaN(n)){
                n = 0;
            }

            resolveBlocks();

            return n ? el("div", null, '[ays_survey id="'+n+'"]') : null
        }
    } );

    function resolveBlocks(id){
        var blocks = id ?
            select('core/block-editor').getBlock(id).innerBlocks
            : select('core/block-editor').getBlocks();

        if ( Array.isArray(blocks) ) {
            blocks.map( function(block){
                if(block.name == 'survey-maker/survey'){
                    if (!block.isValid) {
                        var newBlock = createBlock( block.name, block.attributes, block.innerblocks);
                        dispatch('core/block-editor').replaceBlock( block.clientId, newBlock );
                    } else {
                        resolveBlocks(block.clientId)
                    };
                }
            } );
        };
    };
})(wp);
